/*
 * Decompiled with CFR 0.152.
 */
package org.example.customerdao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.example.customer.Product;
import org.example.customer.Supplier;
import org.example.customer.utility.CustomerEntity;
import org.example.customerdao.ProductDAO;
import org.example.customerdao.utility.ErrorFormatter;
import org.example.customerdao.utility.NonDeleteableRecordException;
import org.example.websecurity.UserCredentials;

public class ProductDAOImpl
implements ProductDAO {
    private static final Logger LOG = LogManager.getLogger();
    private DataSource myReadOnlyDS = null;
    private DataSource myReadWriteDS = null;
    private static final String FIND_ALL_SQL = "Select * from Product";
    private static final String FIND_ALL_ACTIVE_SQL = "Select * from Product where IS_DISCONTINUED = false ";
    private static final String FIND_BY_ID_SQL = "Select * from Product where ID = ?";
    private static final String FIND_BY_SUPPLIER_SQL = "Select * from Product where SUPPLIER_ID = ?";
    private static final String ADD_SQL = "Insert into Product(PRODUCT_NAME,SUPPLIER_ID,UNIT_PRICE,PACKAGE,IS_DISCONTINUED) VALUES(?,?,?,?,?)";
    private static final String UPDATE_SQL = "Update Product set PRODUCT_NAME = ?, SUPPLIER_ID = ?, UNIT_PRICE = ?, PACKAGE = ?, IS_DISCONTINUED = ? WHERE ID = ?";
    private static final String IS_DELETEABLE_PRODUCT_SQL = "Select COUNT(*) from Order_Item where PRODUCT_ID = ?";
    private static final String DELETE_SQL = "Delete from Product where id = ?";

    @Override
    public void setReadOnlyDS(DataSource readOnlyDS) {
        LOG.debug("Setting the ReadOnly DataSource");
        this.myReadOnlyDS = readOnlyDS;
    }

    @Override
    public void setReadWriteDS(DataSource readWriteDS) {
        LOG.debug("Setting the ReadWrite DataSource");
        this.myReadWriteDS = readWriteDS;
    }

    @Override
    public List<Product> findAllProducts(UserCredentials credentials) {
        LOG.debug("findAllProducts");
        if (credentials == null || !credentials.hasRole("worker")) {
            LOG.error("findAllProducts - Permission refused");
            throw new IllegalArgumentException("Permission refused for this operation");
        }
        PreparedStatement findAll = null;
        Connection conn = null;
        ResultSet results = null;
        ArrayList<Product> data = new ArrayList<Product>();
        try {
            try {
                conn = this.myReadOnlyDS.getConnection();
                findAll = conn.prepareStatement(FIND_ALL_SQL);
                results = findAll.executeQuery();
                while (results.next()) {
                    data.add(this.buildProduct(results));
                }
            }
            catch (SQLException sqle) {
                LOG.error("Error finding all Products");
                LOG.error(ErrorFormatter.extractError(sqle));
                throw new IllegalArgumentException(sqle);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly((Connection)conn, findAll, results);
            throw throwable;
        }
        DbUtils.closeQuietly((Connection)conn, (Statement)findAll, (ResultSet)results);
        return data;
    }

    @Override
    public List<Product> findAllActiveProducts(UserCredentials credentials) {
        LOG.debug("findAllActiveProducts");
        if (credentials == null || !credentials.hasRole("worker")) {
            LOG.error("findAllActiveProducts - Permission refused");
            throw new IllegalArgumentException("Permission refused for this operation");
        }
        PreparedStatement findAll = null;
        Connection conn = null;
        ResultSet results = null;
        ArrayList<Product> data = new ArrayList<Product>();
        try {
            try {
                conn = this.myReadOnlyDS.getConnection();
                findAll = conn.prepareStatement(FIND_ALL_ACTIVE_SQL);
                results = findAll.executeQuery();
                while (results.next()) {
                    data.add(this.buildProduct(results));
                }
            }
            catch (SQLException sqle) {
                LOG.error("Error finding all active Products");
                LOG.error(ErrorFormatter.extractError(sqle));
                throw new IllegalArgumentException(sqle);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly((Connection)conn, findAll, results);
            throw throwable;
        }
        DbUtils.closeQuietly((Connection)conn, (Statement)findAll, (ResultSet)results);
        return data;
    }

    @Override
    public Product findProductById(UserCredentials credentials, int id) {
        LOG.debug("findProductById");
        if (credentials == null || !credentials.hasRole("worker")) {
            LOG.error("findProductById - Permission refused");
            throw new IllegalArgumentException("Permission refused for this operation");
        }
        PreparedStatement findById = null;
        Connection conn = null;
        ResultSet results = null;
        Product product = null;
        try {
            try {
                conn = this.myReadOnlyDS.getConnection();
                findById = conn.prepareStatement(FIND_BY_ID_SQL);
                findById.setInt(1, id);
                results = findById.executeQuery();
                if (results.next()) {
                    product = this.buildProduct(results);
                }
            }
            catch (SQLException sqle) {
                LOG.error("Error finding Product by id");
                LOG.error(ErrorFormatter.extractError(sqle));
                throw new IllegalArgumentException(sqle);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly((Connection)conn, findById, results);
            throw throwable;
        }
        DbUtils.closeQuietly((Connection)conn, (Statement)findById, (ResultSet)results);
        return product;
    }

    @Override
    public List<Product> findProductsBySupplier(UserCredentials credentials, Supplier supplier) {
        LOG.debug("findProductsBySupplier");
        if (credentials == null || !credentials.hasRole("worker")) {
            LOG.error("findSuppliersByComapanyName - Permission refused");
            throw new IllegalArgumentException("Permission refused for this operation");
        }
        if (supplier == null) {
            LOG.error("Supplier is required");
            throw new IllegalArgumentException("Supplier is required");
        }
        PreparedStatement findBySupplier = null;
        Connection conn = null;
        ResultSet results = null;
        ArrayList<Product> data = new ArrayList<Product>();
        try {
            try {
                conn = this.myReadOnlyDS.getConnection();
                findBySupplier = conn.prepareStatement(FIND_BY_SUPPLIER_SQL);
                findBySupplier.setInt(1, supplier.getId());
                results = findBySupplier.executeQuery();
                while (results.next()) {
                    data.add(this.buildProduct(results));
                }
            }
            catch (SQLException sqle) {
                LOG.error("Error finding Products by Supplier");
                LOG.error(ErrorFormatter.extractError(sqle));
                throw new IllegalArgumentException(sqle);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly((Connection)conn, findBySupplier, results);
            throw throwable;
        }
        DbUtils.closeQuietly((Connection)conn, (Statement)findBySupplier, (ResultSet)results);
        return data;
    }

    @Override
    public int addProduct(UserCredentials credentials, Product product) {
        LOG.debug("addProduct");
        if (credentials == null || !credentials.hasRole("manager")) {
            LOG.error("addProduct - Permission refused");
            throw new IllegalArgumentException("Permission refused for this operation");
        }
        if (product == null) {
            LOG.error("addProduct - null Product was provided");
            throw new IllegalArgumentException("A Product must be provided");
        }
        PreparedStatement addProduct = null;
        Connection conn = null;
        ResultSet results = null;
        int generatedId = 0;
        try {
            try {
                conn = this.myReadWriteDS.getConnection();
                addProduct = conn.prepareStatement(ADD_SQL, 1);
                String name = product.getProductName();
                int supplierId = product.getSupplierId();
                double unitPrice = product.getUnitPrice();
                String packaging = product.getPackaging();
                boolean discontinued = product.isDiscontinued();
                addProduct.setString(1, name);
                addProduct.setInt(2, supplierId);
                addProduct.setDouble(3, unitPrice);
                addProduct.setString(4, packaging);
                addProduct.setBoolean(5, discontinued);
                addProduct.executeUpdate();
                results = addProduct.getGeneratedKeys();
                if (results.next()) {
                    generatedId = results.getInt(1);
                }
            }
            catch (SQLException sqle) {
                LOG.error("Error adding Product");
                LOG.error(ErrorFormatter.extractError(sqle));
                throw new IllegalArgumentException(sqle);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly((Connection)conn, addProduct, results);
            throw throwable;
        }
        DbUtils.closeQuietly((Connection)conn, (Statement)addProduct, (ResultSet)results);
        return generatedId;
    }

    @Override
    public void updateProduct(UserCredentials credentials, Product product) {
        LOG.debug("updateProduct");
        if (credentials == null || !credentials.hasRole("manager")) {
            LOG.error("updateProduct - Permission refused");
            throw new IllegalArgumentException("Permission refused for this operation");
        }
        if (product == null) {
            LOG.error("updateProduct - null Product was provided");
            throw new IllegalArgumentException("A Product must be provided");
        }
        PreparedStatement updateProduct = null;
        Connection conn = null;
        try {
            try {
                conn = this.myReadWriteDS.getConnection();
                updateProduct = conn.prepareStatement(UPDATE_SQL);
                int id = product.getId();
                String name = product.getProductName();
                int supplierId = product.getSupplierId();
                double unitPrice = product.getUnitPrice();
                String packaging = product.getPackaging();
                boolean discontinued = product.isDiscontinued();
                updateProduct.setString(1, name);
                updateProduct.setInt(2, supplierId);
                updateProduct.setDouble(3, unitPrice);
                updateProduct.setString(4, packaging);
                updateProduct.setBoolean(5, discontinued);
                updateProduct.setInt(6, id);
                updateProduct.executeUpdate();
            }
            catch (SQLException sqle) {
                LOG.error("Error updating Product");
                LOG.error(ErrorFormatter.extractError(sqle));
                throw new IllegalArgumentException(sqle);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(updateProduct);
            DbUtils.closeQuietly((Connection)conn);
            throw throwable;
        }
        DbUtils.closeQuietly((Statement)updateProduct);
        DbUtils.closeQuietly((Connection)conn);
    }

    @Override
    public boolean isDeleteable(UserCredentials credentials, CustomerEntity entity) {
        LOG.debug("isDeleteable");
        if (credentials == null || entity == null) {
            LOG.error("isDeleteable - null Product was provided");
            throw new IllegalArgumentException("A Product must be provided");
        }
        return this.isDeleteable(credentials, entity.getId());
    }

    @Override
    public boolean isDeleteable(UserCredentials credentials, int id) {
        LOG.debug("isDeleteable");
        if (credentials == null || !credentials.hasRole("worker")) {
            LOG.error("isDeleteable - Permission refused");
            throw new IllegalArgumentException("Permission refused for this operation");
        }
        PreparedStatement isDeleteable = null;
        Connection conn = null;
        ResultSet results = null;
        boolean isDeleteableResult = false;
        try {
            try {
                int count;
                conn = this.myReadOnlyDS.getConnection();
                isDeleteable = conn.prepareStatement(IS_DELETEABLE_PRODUCT_SQL);
                isDeleteable.setInt(1, id);
                results = isDeleteable.executeQuery();
                if (results.next() && (count = results.getInt(1)) == 0) {
                    isDeleteableResult = true;
                }
            }
            catch (SQLException sqle) {
                LOG.error("Error finding Orders by Product");
                LOG.error(ErrorFormatter.extractError(sqle));
                throw new IllegalArgumentException(sqle);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly((Connection)conn, isDeleteable, results);
            throw throwable;
        }
        DbUtils.closeQuietly((Connection)conn, (Statement)isDeleteable, (ResultSet)results);
        return isDeleteableResult;
    }

    @Override
    public void deleteEntity(UserCredentials credentials, CustomerEntity entity) throws NonDeleteableRecordException {
        LOG.debug("deleteProduct");
        if (entity == null) {
            LOG.error("deleteProduct - null Product was provided");
            throw new IllegalArgumentException("A Product must be provided");
        }
        if (!(entity instanceof Product)) {
            LOG.error("deleteProduct - invalid CustomerEntity was provided");
            throw new IllegalArgumentException("A Product must be provided");
        }
        this.deleteEntity(credentials, entity.getId());
    }

    @Override
    public void deleteEntity(UserCredentials credentials, int id) throws NonDeleteableRecordException {
        LOG.debug("deleteProduct");
        if (credentials == null || !credentials.hasRole("manager")) {
            LOG.error("deleteProduct - Permission refused");
            throw new IllegalArgumentException("Permission refused for this operation");
        }
        if (!this.isDeleteable(credentials, id)) {
            LOG.error("Product not deleteable");
            throw new NonDeleteableRecordException("This Product is not deletable");
        }
        PreparedStatement deleteProduct = null;
        Connection conn = null;
        try {
            try {
                conn = this.myReadWriteDS.getConnection();
                deleteProduct = conn.prepareStatement(DELETE_SQL);
                deleteProduct.setInt(1, id);
                deleteProduct.executeUpdate();
            }
            catch (SQLException sqle) {
                LOG.error("Error updating Product");
                LOG.error(ErrorFormatter.extractError(sqle));
                throw new IllegalArgumentException(sqle);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(deleteProduct);
            DbUtils.closeQuietly((Connection)conn);
            throw throwable;
        }
        DbUtils.closeQuietly((Statement)deleteProduct);
        DbUtils.closeQuietly((Connection)conn);
    }

    private Product buildProduct(ResultSet results) throws SQLException {
        Product current = new Product();
        current.setId(results.getInt("ID"));
        current.setProductName(results.getString("PRODUCT_NAME").trim());
        current.setSupplierId(results.getInt("SUPPLIER_ID"));
        current.setUnitPrice(results.getDouble("UNIT_PRICE"));
        current.setPackaging(results.getString("PACKAGE"));
        current.setDiscontinued(results.getBoolean("IS_DISCONTINUED"));
        LOG.trace("Found Product: " + current.toString());
        return current;
    }
}

