/*
 * Decompiled with CFR 0.152.
 */
package org.example.customerdao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.example.customer.Supplier;
import org.example.customer.utility.CustomerEntity;
import org.example.customer.utility.Location;
import org.example.customer.utility.Phone;
import org.example.customerdao.SupplierDAO;
import org.example.customerdao.utility.ErrorFormatter;
import org.example.customerdao.utility.NonDeleteableRecordException;
import org.example.websecurity.UserCredentials;

public class SupplierDAOImpl
implements SupplierDAO {
    private static final Logger LOG = LogManager.getLogger();
    private DataSource myReadOnlyDS = null;
    private DataSource myReadWriteDS = null;
    private static final String FIND_ALL_SQL = "Select * from Supplier";
    private static final String FIND_BY_ID_SQL = "Select * from Supplier where ID = ?";
    private static final String FIND_BY_COMPANY_SQL = "Select * from Supplier where COMPANY_NAME Like ?";
    private static final String ADD_SQL = "Insert into Supplier(COMPANY_NAME,CONTACT_NAME,CITY,COUNTRY,PHONE, FAX) VALUES(?,?,?,?,?,?)";
    private static final String UPDATE_SQL = "Update Supplier set COMPANY_NAME = ?, CONTACT_NAME = ?, CITY = ?, COUNTRY = ?, PHONE = ?, FAX = ? WHERE ID = ?";
    private static final String IS_DELETEABLE_SUPPLIER_SQL = "Select COUNT(*) from Product where SUPPLIER_ID = ?";
    private static final String DELETE_SQL = "Delete from Supplier where id = ?";

    @Override
    public void setReadOnlyDS(DataSource readOnlyDS) {
        LOG.debug("Setting the ReadOnly DataSource");
        this.myReadOnlyDS = readOnlyDS;
    }

    @Override
    public void setReadWriteDS(DataSource readWriteDS) {
        LOG.debug("Setting the ReadWrite DataSource");
        this.myReadWriteDS = readWriteDS;
    }

    @Override
    public List<Supplier> findAllSuppliers(UserCredentials credentials) {
        LOG.debug("findAllSuppliers");
        if (credentials == null || !credentials.hasRole("worker")) {
            LOG.error("findAllSuppliers - Permission refused");
            throw new IllegalArgumentException("Permission refused for this operation");
        }
        PreparedStatement findAll = null;
        Connection conn = null;
        ResultSet results = null;
        ArrayList<Supplier> data = new ArrayList<Supplier>();
        try {
            try {
                conn = this.myReadOnlyDS.getConnection();
                findAll = conn.prepareStatement(FIND_ALL_SQL);
                results = findAll.executeQuery();
                while (results.next()) {
                    data.add(this.buildSupplier(results));
                }
            }
            catch (SQLException sqle) {
                LOG.error("Error finding all Suppliers");
                LOG.error(ErrorFormatter.extractError(sqle));
                throw new IllegalArgumentException(sqle);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly((Connection)conn, findAll, results);
            throw throwable;
        }
        DbUtils.closeQuietly((Connection)conn, (Statement)findAll, (ResultSet)results);
        return data;
    }

    @Override
    public Supplier findSupplierById(UserCredentials credentials, int id) {
        LOG.debug("findSupplierById");
        if (credentials == null || !credentials.hasRole("worker")) {
            LOG.error("findSupplierById - Permission refused");
            throw new IllegalArgumentException("Permission refused for this operation");
        }
        PreparedStatement findById = null;
        Connection conn = null;
        ResultSet results = null;
        Supplier supplier = null;
        try {
            try {
                conn = this.myReadOnlyDS.getConnection();
                findById = conn.prepareStatement(FIND_BY_ID_SQL);
                findById.setInt(1, id);
                results = findById.executeQuery();
                if (results.next()) {
                    supplier = this.buildSupplier(results);
                }
            }
            catch (SQLException sqle) {
                LOG.error("Error finding Supplier by id");
                LOG.error(ErrorFormatter.extractError(sqle));
                throw new IllegalArgumentException(sqle);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly((Connection)conn, findById, results);
            throw throwable;
        }
        DbUtils.closeQuietly((Connection)conn, (Statement)findById, (ResultSet)results);
        return supplier;
    }

    @Override
    public List<Supplier> findSuppliersByCompanyName(UserCredentials credentials, String name) {
        LOG.debug("findSuppliersByComapanyName");
        if (credentials == null || !credentials.hasRole("worker")) {
            LOG.error("findSuppliersByComapanyName - Permission refused");
            throw new IllegalArgumentException("Permission refused for this operation");
        }
        PreparedStatement findByName = null;
        Connection conn = null;
        ResultSet results = null;
        ArrayList<Supplier> data = new ArrayList<Supplier>();
        try {
            try {
                conn = this.myReadOnlyDS.getConnection();
                findByName = conn.prepareStatement(FIND_BY_COMPANY_SQL);
                findByName.setString(1, "%" + name + "%");
                results = findByName.executeQuery();
                while (results.next()) {
                    data.add(this.buildSupplier(results));
                }
            }
            catch (SQLException sqle) {
                LOG.error("Error finding all Suppliers");
                LOG.error(ErrorFormatter.extractError(sqle));
                throw new IllegalArgumentException(sqle);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly((Connection)conn, findByName, results);
            throw throwable;
        }
        DbUtils.closeQuietly((Connection)conn, (Statement)findByName, (ResultSet)results);
        return data;
    }

    @Override
    public int addSupplier(UserCredentials credentials, Supplier supplier) {
        LOG.debug("addSupplier");
        if (credentials == null || !credentials.hasRole("manager")) {
            LOG.error("addSupplier - Permission refused");
            throw new IllegalArgumentException("Permission refused for this operation");
        }
        if (supplier == null) {
            LOG.error("addSupplier - null Supplier was provided");
            throw new IllegalArgumentException("A Supplier must be provided");
        }
        PreparedStatement addSupplier = null;
        Connection conn = null;
        ResultSet results = null;
        int generatedId = 0;
        try {
            try {
                conn = this.myReadWriteDS.getConnection();
                addSupplier = conn.prepareStatement(ADD_SQL, 1);
                String company = supplier.getCompanyName();
                String contact = supplier.getContactName();
                Location location = supplier.getLocation();
                String city = location.getCity();
                String country = location.getCountry();
                Phone phone = supplier.getPhone();
                String number = phone.getNumber();
                Phone fax = supplier.getFax();
                String faxNumber = fax.getNumber();
                addSupplier.setString(1, company);
                addSupplier.setString(2, contact);
                addSupplier.setString(3, city);
                addSupplier.setString(4, country);
                addSupplier.setString(5, number);
                addSupplier.setString(6, faxNumber);
                addSupplier.executeUpdate();
                results = addSupplier.getGeneratedKeys();
                if (results.next()) {
                    generatedId = results.getInt(1);
                }
            }
            catch (SQLException sqle) {
                LOG.error("Error adding Supplier");
                LOG.error(ErrorFormatter.extractError(sqle));
                throw new IllegalArgumentException(sqle);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly((Connection)conn, addSupplier, results);
            throw throwable;
        }
        DbUtils.closeQuietly((Connection)conn, (Statement)addSupplier, (ResultSet)results);
        return generatedId;
    }

    @Override
    public void updateSupplier(UserCredentials credentials, Supplier supplier) {
        LOG.debug("updateSupplier");
        if (credentials == null || !credentials.hasRole("manager")) {
            LOG.error("updateSupplier - Permission refused");
            throw new IllegalArgumentException("Permission refused for this operation");
        }
        if (supplier == null) {
            LOG.error("updateSupplier - null Supplier was provided");
            throw new IllegalArgumentException("A Supplier must be provided");
        }
        PreparedStatement updateSupplier = null;
        Connection conn = null;
        try {
            try {
                conn = this.myReadWriteDS.getConnection();
                updateSupplier = conn.prepareStatement(UPDATE_SQL);
                int id = supplier.getId();
                String company = supplier.getCompanyName();
                String contact = supplier.getContactName();
                Location location = supplier.getLocation();
                String city = location.getCity();
                String country = location.getCountry();
                String number = null;
                Phone phone = supplier.getPhone();
                if (phone != null) {
                    number = phone.getNumber();
                }
                String faxNumber = null;
                Phone fax = supplier.getFax();
                if (fax != null) {
                    faxNumber = fax.getNumber();
                }
                updateSupplier.setString(1, company);
                updateSupplier.setString(2, contact);
                updateSupplier.setString(3, city);
                updateSupplier.setString(4, country);
                updateSupplier.setString(5, number);
                updateSupplier.setString(6, faxNumber);
                updateSupplier.setInt(7, id);
                updateSupplier.executeUpdate();
            }
            catch (SQLException sqle) {
                LOG.error("Error updating Supplier");
                LOG.error(ErrorFormatter.extractError(sqle));
                throw new IllegalArgumentException(sqle);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(updateSupplier);
            DbUtils.closeQuietly((Connection)conn);
            throw throwable;
        }
        DbUtils.closeQuietly((Statement)updateSupplier);
        DbUtils.closeQuietly((Connection)conn);
    }

    @Override
    public boolean isDeleteable(UserCredentials credentials, CustomerEntity entity) {
        LOG.debug("isDeleteable");
        if (credentials == null || entity == null) {
            LOG.error("isDeleteable - null Supplier was provided");
            throw new IllegalArgumentException("A Supplier must be provided");
        }
        return this.isDeleteable(credentials, entity.getId());
    }

    @Override
    public boolean isDeleteable(UserCredentials credentials, int id) {
        LOG.debug("isDeleteable");
        if (credentials == null || !credentials.hasRole("worker")) {
            LOG.error("isDeleteable - Permission refused");
            throw new IllegalArgumentException("Permission refused for this operation");
        }
        PreparedStatement isDeleteable = null;
        Connection conn = null;
        ResultSet results = null;
        boolean isDeleteableResult = false;
        try {
            try {
                int count;
                conn = this.myReadOnlyDS.getConnection();
                isDeleteable = conn.prepareStatement(IS_DELETEABLE_SUPPLIER_SQL);
                isDeleteable.setInt(1, id);
                results = isDeleteable.executeQuery();
                if (results.next() && (count = results.getInt(1)) == 0) {
                    isDeleteableResult = true;
                }
            }
            catch (SQLException sqle) {
                LOG.error("Error finding Product by Supplier");
                LOG.error(ErrorFormatter.extractError(sqle));
                throw new IllegalArgumentException(sqle);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly((Connection)conn, isDeleteable, results);
            throw throwable;
        }
        DbUtils.closeQuietly((Connection)conn, (Statement)isDeleteable, (ResultSet)results);
        return isDeleteableResult;
    }

    @Override
    public void deleteEntity(UserCredentials credentials, CustomerEntity entity) throws NonDeleteableRecordException {
        LOG.debug("deleteSupplier");
        if (entity == null) {
            LOG.error("deleteSupplier - null Supplier was provided");
            throw new IllegalArgumentException("A Supplier must be provided");
        }
        if (!(entity instanceof Supplier)) {
            LOG.error("deleteSupplier - invalid CustomerEntity was provided");
            throw new IllegalArgumentException("A Supplier must be provided");
        }
        this.deleteEntity(credentials, entity.getId());
    }

    @Override
    public void deleteEntity(UserCredentials credentials, int id) throws NonDeleteableRecordException {
        LOG.debug("deleteSupplier");
        if (credentials == null || !credentials.hasRole("manager")) {
            LOG.error("deleteSupplier - Permission refused");
            throw new IllegalArgumentException("Permission refused for this operation");
        }
        if (!this.isDeleteable(credentials, id)) {
            LOG.error("Supplier not deleteable");
            throw new NonDeleteableRecordException("This Supplier is not deletable");
        }
        PreparedStatement deleteSupplier = null;
        Connection conn = null;
        try {
            try {
                conn = this.myReadWriteDS.getConnection();
                deleteSupplier = conn.prepareStatement(DELETE_SQL);
                deleteSupplier.setInt(1, id);
                deleteSupplier.executeUpdate();
            }
            catch (SQLException sqle) {
                LOG.error("Error updating Supplier");
                LOG.error(ErrorFormatter.extractError(sqle));
                throw new IllegalArgumentException(sqle);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(deleteSupplier);
            DbUtils.closeQuietly((Connection)conn);
            throw throwable;
        }
        DbUtils.closeQuietly((Statement)deleteSupplier);
        DbUtils.closeQuietly((Connection)conn);
    }

    private Supplier buildSupplier(ResultSet results) throws SQLException {
        Supplier current = new Supplier();
        current.setId(results.getInt("ID"));
        current.setCompanyName(results.getString("COMPANY_NAME").trim());
        current.setContactName(results.getString("CONTACT_NAME").trim());
        Location location = new Location();
        location.setCity(results.getString("CITY").trim());
        location.setCountry(results.getString("COUNTRY").trim());
        current.setLocation(location);
        String temp = results.getString("Phone");
        if (temp != null) {
            Phone phone = new Phone();
            phone.setNumber(temp.trim());
            current.setPhone(phone);
        } else {
            current.setPhone(null);
        }
        temp = results.getString("Fax");
        if (temp != null) {
            Phone fax = new Phone();
            fax.setNumber(temp.trim());
            current.setFax(fax);
        } else {
            current.setFax(null);
        }
        LOG.trace("Found Supplier: " + current.toString());
        return current;
    }
}

