/*
 * Decompiled with CFR 0.152.
 */
package org.example.customerdao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.example.customer.Customer;
import org.example.customer.utility.CustomerEntity;
import org.example.customer.utility.Location;
import org.example.customer.utility.Phone;
import org.example.customerdao.CustomerDAO;
import org.example.customerdao.utility.ErrorFormatter;
import org.example.customerdao.utility.NonDeleteableRecordException;
import org.example.websecurity.UserCredentials;

public final class CustomerDAOImpl
implements CustomerDAO {
    private static final Logger LOG = LogManager.getLogger();
    private DataSource myReadOnlyDS = null;
    private DataSource myReadWriteDS = null;
    private static final String FIND_ALL_SQL = "Select * from Customer";
    private static final String FIND_BY_ID_SQL = "Select * from Customer where ID = ?";
    private static final String FIND_BY_NAME_SQL = "Select * from Customer where FIRST_NAME = ? AND LAST_NAME = ?";
    private static final String ADD_SQL = "Insert into Customer(FIRST_NAME,LAST_NAME,CITY,COUNTRY,PHONE) VALUES(?,?,?,?,?)";
    private static final String UPDATE_SQL = "Update Customer set FIRST_NAME = ?, LAST_NAME = ?, CITY = ?, COUNTRY = ?, PHONE = ? WHERE ID = ?";
    private static final String IS_DELETEABLE_CUSTOMER_SQL = "Select COUNT(*) from Orders where CUSTOMER_ID = ?";
    private static final String DELETE_SQL = "Delete from Customer where id = ?";

    @Override
    public void setReadOnlyDS(DataSource readOnlyDS) {
        LOG.debug("Setting the ReadOnly DataSource");
        this.myReadOnlyDS = readOnlyDS;
    }

    @Override
    public void setReadWriteDS(DataSource readWriteDS) {
        LOG.debug("Setting the ReadWrite DataSource");
        this.myReadWriteDS = readWriteDS;
    }

    @Override
    public List<Customer> findAllCustomers(UserCredentials credentials) {
        LOG.debug("findAllCustomers");
        if (credentials == null || !credentials.hasRole("worker")) {
            LOG.error("findAllCustomers - Permission refused");
            throw new IllegalArgumentException("Permission refused for this operation");
        }
        PreparedStatement findAll = null;
        Connection conn = null;
        ResultSet results = null;
        ArrayList<Customer> data = new ArrayList<Customer>();
        try {
            try {
                conn = this.myReadOnlyDS.getConnection();
                findAll = conn.prepareStatement(FIND_ALL_SQL);
                results = findAll.executeQuery();
                while (results.next()) {
                    data.add(this.buildCustomer(results));
                }
            }
            catch (SQLException sqle) {
                LOG.error("Error finding all Customers");
                LOG.error(ErrorFormatter.extractError(sqle));
                throw new IllegalArgumentException(sqle);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly((Connection)conn, findAll, results);
            throw throwable;
        }
        DbUtils.closeQuietly((Connection)conn, (Statement)findAll, (ResultSet)results);
        return data;
    }

    @Override
    public Customer findCustomerById(UserCredentials credentials, int id) {
        LOG.debug("findCustomerById");
        if (credentials == null || !credentials.hasRole("worker")) {
            LOG.error("findCustomerById - Permission refused");
            throw new IllegalArgumentException("Permission refused for this operation");
        }
        PreparedStatement findById = null;
        Connection conn = null;
        ResultSet results = null;
        Customer customer = null;
        try {
            try {
                conn = this.myReadOnlyDS.getConnection();
                findById = conn.prepareStatement(FIND_BY_ID_SQL);
                findById.setInt(1, id);
                results = findById.executeQuery();
                if (results.next()) {
                    customer = this.buildCustomer(results);
                }
            }
            catch (SQLException sqle) {
                LOG.error("Error finding Customer by id");
                LOG.error(ErrorFormatter.extractError(sqle));
                throw new IllegalArgumentException(sqle);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly((Connection)conn, findById, results);
            throw throwable;
        }
        DbUtils.closeQuietly((Connection)conn, (Statement)findById, (ResultSet)results);
        return customer;
    }

    @Override
    public List<Customer> findCustomersByName(UserCredentials credentials, String firstName, String lastName) {
        LOG.debug("findCustomersByName");
        if (credentials == null || !credentials.hasRole("worker")) {
            LOG.error("findCustomersByName - Permission refused");
            throw new IllegalArgumentException("Permission refused for this operation");
        }
        if (firstName == null || lastName == null) {
            LOG.error("findCustomersByName - names are required");
            throw new IllegalArgumentException("A first name and a last name are required");
        }
        PreparedStatement findByName = null;
        Connection conn = null;
        ResultSet results = null;
        ArrayList<Customer> data = new ArrayList<Customer>();
        try {
            try {
                conn = this.myReadOnlyDS.getConnection();
                findByName = conn.prepareStatement(FIND_BY_NAME_SQL);
                findByName.setString(1, firstName);
                findByName.setString(2, lastName);
                results = findByName.executeQuery();
                while (results.next()) {
                    data.add(this.buildCustomer(results));
                }
            }
            catch (SQLException sqle) {
                LOG.error("Error finding Customer by name");
                LOG.error(ErrorFormatter.extractError(sqle));
                throw new IllegalArgumentException(sqle);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly((Connection)conn, findByName, results);
            throw throwable;
        }
        DbUtils.closeQuietly((Connection)conn, (Statement)findByName, (ResultSet)results);
        return data;
    }

    @Override
    public int addCustomer(UserCredentials credentials, Customer customer) {
        LOG.debug("addCustomer");
        if (credentials == null || !credentials.hasRole("manager")) {
            LOG.error("addCustomer - Permission refused");
            throw new IllegalArgumentException("Permission refused for this operation");
        }
        if (customer == null) {
            LOG.error("addCustomer - null Customer was provided");
            throw new IllegalArgumentException("A Customer must be provided");
        }
        PreparedStatement addCustomer = null;
        Connection conn = null;
        ResultSet results = null;
        int generatedId = 0;
        try {
            try {
                conn = this.myReadWriteDS.getConnection();
                addCustomer = conn.prepareStatement(ADD_SQL, 1);
                String firstName = customer.getFirstName();
                String lastName = customer.getLastName();
                Location location = customer.getLocation();
                String city = location.getCity();
                String country = location.getCountry();
                Phone phone = customer.getPhone();
                String number = phone.getNumber();
                addCustomer.setString(1, firstName);
                addCustomer.setString(2, lastName);
                addCustomer.setString(3, city);
                addCustomer.setString(4, country);
                addCustomer.setString(5, number);
                addCustomer.executeUpdate();
                results = addCustomer.getGeneratedKeys();
                if (results.next()) {
                    generatedId = results.getInt(1);
                }
            }
            catch (SQLException sqle) {
                LOG.error("Error adding Customer");
                LOG.error(ErrorFormatter.extractError(sqle));
                throw new IllegalArgumentException(sqle);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly((Connection)conn, addCustomer, results);
            throw throwable;
        }
        DbUtils.closeQuietly((Connection)conn, (Statement)addCustomer, (ResultSet)results);
        return generatedId;
    }

    @Override
    public void updateCustomer(UserCredentials credentials, Customer customer) {
        LOG.debug("updateCustomer");
        if (credentials == null || !credentials.hasRole("manager")) {
            LOG.error("updateCustomer - Permission refused");
            throw new IllegalArgumentException("Permission refused for this operation");
        }
        if (customer == null) {
            LOG.error("updateCustomer - null Customer was provided");
            throw new IllegalArgumentException("A Customer must be provided");
        }
        PreparedStatement updateCustomer = null;
        Connection conn = null;
        try {
            try {
                conn = this.myReadWriteDS.getConnection();
                updateCustomer = conn.prepareStatement(UPDATE_SQL);
                int id = customer.getId();
                String firstName = customer.getFirstName();
                String lastName = customer.getLastName();
                Location location = customer.getLocation();
                String city = location.getCity();
                String country = location.getCountry();
                String number = null;
                Phone phone = customer.getPhone();
                if (phone != null) {
                    number = phone.getNumber();
                }
                updateCustomer.setString(1, firstName);
                updateCustomer.setString(2, lastName);
                updateCustomer.setString(3, city);
                updateCustomer.setString(4, country);
                updateCustomer.setString(5, number);
                updateCustomer.setInt(6, id);
                updateCustomer.executeUpdate();
            }
            catch (SQLException sqle) {
                LOG.error("Error updating Customer");
                LOG.error(ErrorFormatter.extractError(sqle));
                throw new IllegalArgumentException(sqle);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(updateCustomer);
            DbUtils.closeQuietly((Connection)conn);
            throw throwable;
        }
        DbUtils.closeQuietly((Statement)updateCustomer);
        DbUtils.closeQuietly((Connection)conn);
    }

    @Override
    public boolean isDeleteable(UserCredentials credentials, int id) {
        LOG.debug("isDeleteable");
        if (credentials == null || !credentials.hasRole("worker")) {
            LOG.error("isDeleteable - Permission refused");
            throw new IllegalArgumentException("Permission refused for this operation");
        }
        PreparedStatement isDeleteable = null;
        Connection conn = null;
        ResultSet results = null;
        boolean isDeleteableResult = false;
        try {
            try {
                int count;
                conn = this.myReadOnlyDS.getConnection();
                isDeleteable = conn.prepareStatement(IS_DELETEABLE_CUSTOMER_SQL);
                isDeleteable.setInt(1, id);
                results = isDeleteable.executeQuery();
                if (results.next() && (count = results.getInt(1)) == 0) {
                    isDeleteableResult = true;
                }
            }
            catch (SQLException sqle) {
                LOG.error("Error finding Customer by Order");
                LOG.error(ErrorFormatter.extractError(sqle));
                throw new IllegalArgumentException(sqle);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly((Connection)conn, isDeleteable, results);
            throw throwable;
        }
        DbUtils.closeQuietly((Connection)conn, (Statement)isDeleteable, (ResultSet)results);
        return isDeleteableResult;
    }

    @Override
    public boolean isDeleteable(UserCredentials credentials, CustomerEntity entity) {
        LOG.debug("isDeleteable");
        if (credentials == null || entity == null) {
            LOG.error("isDeleteable - null Customer was provided");
            throw new IllegalArgumentException("A Customer must be provided");
        }
        if (!(entity instanceof Customer)) {
            LOG.error("isDeleteable - invalid CustomerEntity was provided");
            throw new IllegalArgumentException("A Customer must be provided");
        }
        return this.isDeleteable(credentials, entity.getId());
    }

    @Override
    public void deleteEntity(UserCredentials credentials, CustomerEntity entity) {
        LOG.debug("deleteCustomer");
        if (entity == null) {
            LOG.error("deleteCustomer - null Customer was provided");
            throw new IllegalArgumentException("A Customer must be provided");
        }
        if (!(entity instanceof Customer)) {
            LOG.error("deleteCustomer - invalid CustomerEntity was provided");
            throw new IllegalArgumentException("A Customer must be provided");
        }
        this.deleteEntity(credentials, entity.getId());
    }

    @Override
    public void deleteEntity(UserCredentials credentials, int id) {
        LOG.debug("deleteCustomer");
        if (credentials == null || !credentials.hasRole("manager")) {
            LOG.error("deleteCustomer - Permission refused");
            throw new IllegalArgumentException("Permission refused for this operation");
        }
        if (!this.isDeleteable(credentials, id)) {
            LOG.error("Customer not deleteable");
            throw new NonDeleteableRecordException("This Customer is not deletable");
        }
        PreparedStatement deleteCustomer = null;
        Connection conn = null;
        try {
            try {
                conn = this.myReadWriteDS.getConnection();
                deleteCustomer = conn.prepareStatement(DELETE_SQL);
                deleteCustomer.setInt(1, id);
                deleteCustomer.executeUpdate();
            }
            catch (SQLException sqle) {
                LOG.error("Error updating Customer");
                LOG.error(ErrorFormatter.extractError(sqle));
                throw new IllegalArgumentException(sqle);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(deleteCustomer);
            DbUtils.closeQuietly((Connection)conn);
            throw throwable;
        }
        DbUtils.closeQuietly((Statement)deleteCustomer);
        DbUtils.closeQuietly((Connection)conn);
    }

    private Customer buildCustomer(ResultSet results) throws SQLException {
        Customer current = new Customer();
        current.setId(results.getInt("ID"));
        current.setFirstName(results.getString("FIRST_NAME").trim());
        current.setLastName(results.getString("LAST_NAME").trim());
        Location location = new Location();
        location.setCity(results.getString("CITY").trim());
        location.setCountry(results.getString("COUNTRY").trim());
        current.setLocation(location);
        Phone phone = new Phone();
        phone.setNumber(results.getString("Phone").trim());
        current.setPhone(phone);
        LOG.trace("Found Customer: " + current.toString());
        return current;
    }
}

