/*
 * Decompiled with CFR 0.152.
 */
package org.example.customer;

import java.io.Serializable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.example.customer.utility.CustomerEntity;
import org.example.websecurity.XssSanitizer;
import org.example.websecurity.XssSanitizerImpl;

public final class Product
extends CustomerEntity
implements Serializable,
Comparable<Product> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger();
    private String myProductName;
    private int mySupplierId;
    private double myUnitPrice;
    private String myPackaging;
    private boolean myDiscontinued;
    private XssSanitizer mySanitizer;

    public Product() {
        this((XssSanitizer)new XssSanitizerImpl());
        LOG.debug("Finishing the default Constructor");
    }

    public Product(XssSanitizer sanitizer) {
        LOG.debug("Starting the overloaded Constructor");
        boolean initialId = true;
        String initialProductName = "Paper Envelope";
        boolean initialSupplierId = true;
        double initialUnitPrice = 0.01;
        String initialPackaging = "single";
        boolean initialDiscontinued = false;
        this.mySanitizer = sanitizer;
        this.setId(1);
        this.setProductName("Paper Envelope");
        this.setSupplierId(1);
        this.setUnitPrice(0.01);
        this.setPackaging("single");
        this.setDiscontinued(false);
    }

    @Override
    public int compareTo(Product other) {
        return this.getProductName().compareToIgnoreCase(other.getProductName());
    }

    public String getProductName() {
        LOG.debug("returning the Product Name: " + this.myProductName);
        return this.myProductName;
    }

    public void setProductName(String productName) {
        LOG.debug("setting the Product Name");
        int max = 50;
        if (productName == null) {
            LOG.error("Product Name must not be null");
            throw new IllegalArgumentException("Product Name must not be null");
        }
        String safeProductName = this.mySanitizer.sanitizeInput(productName);
        if (safeProductName.isEmpty()) {
            LOG.error("Product Name must not be empty");
            throw new IllegalArgumentException("Product Name must not be empty");
        }
        if (safeProductName.length() > 50) {
            LOG.error("Product Name must be up to 50 chars in length");
            throw new IllegalArgumentException("Product Name must be up to 50 chars in length");
        }
        LOG.debug("setting the Product Name to: " + safeProductName);
        this.myProductName = safeProductName;
    }

    public int getSupplierId() {
        LOG.debug("returning the SupplierId: " + this.mySupplierId);
        return this.mySupplierId;
    }

    public void setSupplierId(int supplierId) {
        LOG.debug("setting the SuppliierId: " + supplierId);
        boolean min = true;
        if (supplierId < 1) {
            LOG.error("SupplierId must be greater then zero");
            throw new IllegalArgumentException("SupplierId must be greater then zero");
        }
        this.mySupplierId = supplierId;
    }

    public double getUnitPrice() {
        LOG.debug("returning the UnitPrice: " + this.myUnitPrice);
        return this.myUnitPrice;
    }

    public void setUnitPrice(double unitPrice) {
        LOG.debug("setting the unitPrice: " + unitPrice);
        double min = 0.01;
        if (unitPrice < 0.01) {
            LOG.error("unitPrice must be greater then zero");
            throw new IllegalArgumentException("unitPrice must be greater then zero");
        }
        this.myUnitPrice = unitPrice;
    }

    public String getPackaging() {
        LOG.debug("returning the Packaging: " + this.myPackaging);
        return this.myPackaging;
    }

    public void setPackaging(String packaging) {
        LOG.debug("setting the Packaging");
        int max = 30;
        int min = 2;
        if (packaging == null) {
            LOG.debug("Packaging is set to null");
            this.myPackaging = null;
            return;
        }
        String safePackaging = this.mySanitizer.sanitizeInput(packaging);
        if (safePackaging.isEmpty()) {
            LOG.error("Packaging must not be empty");
            throw new IllegalArgumentException("Packaging must not be empty");
        }
        if (safePackaging.length() > 30 || safePackaging.length() < 2) {
            LOG.error("Packaging must be between 2 and 30 chars in length");
            throw new IllegalArgumentException("Packaging must be between 2 and 30 chars in length");
        }
        LOG.debug("setting the Packaging to: " + safePackaging);
        this.myPackaging = safePackaging;
    }

    public boolean isDiscontinued() {
        LOG.debug("returning the Discontinued: " + this.myDiscontinued);
        return this.myDiscontinued;
    }

    public void setDiscontinued(boolean discontinued) {
        LOG.debug("setting the discontinued value to: " + discontinued);
        this.myDiscontinued = discontinued;
    }

    @Override
    public int hashCode() {
        LOG.debug("building HashCode");
        return new HashCodeBuilder().append(this.getId()).append((Object)this.myProductName).append(this.mySupplierId).append(this.myUnitPrice).append((Object)this.myPackaging).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        LOG.debug("checking equals");
        if (obj instanceof Product) {
            Product other = (Product)obj;
            return new EqualsBuilder().append(this.getId(), other.getId()).append((Object)this.myProductName, (Object)other.myProductName).append(this.mySupplierId, other.mySupplierId).append(this.myUnitPrice, other.myUnitPrice).append((Object)this.myPackaging, (Object)other.myPackaging).isEquals();
        }
        return false;
    }

    @Override
    public String toString() {
        LOG.debug("calling toString()");
        return "Product [Id=" + this.getId() + ", ProductName=" + this.myProductName + ", SupplierId=" + this.mySupplierId + ", UnitPrice=" + this.myUnitPrice + ", Packaging=" + this.myPackaging + ", Discontinued=" + this.myDiscontinued + "]";
    }
}

