/*
 * Decompiled with CFR 0.152.
 */
package org.example.customer;

import java.io.Serializable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.example.customer.utility.CustomerEntity;
import org.example.customer.utility.Location;
import org.example.customer.utility.Phone;
import org.example.websecurity.XssSanitizer;
import org.example.websecurity.XssSanitizerImpl;

public class Supplier
extends CustomerEntity
implements Serializable,
Comparable<Supplier> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger();
    private String myCompanyName;
    private String myContactName;
    private Location myLocation;
    private Phone myPhone;
    private Phone myFax;
    private XssSanitizer mySanitizer;

    public Supplier() {
        this((XssSanitizer)new XssSanitizerImpl());
        LOG.debug("Finishing the default Constructor");
    }

    public Supplier(XssSanitizer sanitizer) {
        LOG.debug("Starting the overloaded Constructor");
        boolean initialId = true;
        String initialCompanyName = "ABC Inc.";
        String initialContactName = "John Smith";
        String initialCity = "New York City";
        String initialCountry = "United States of America";
        String initialPhoneNumber = null;
        String initialFaxNumber = null;
        this.mySanitizer = sanitizer;
        this.setId(1);
        this.setCompanyName("ABC Inc.");
        this.setContactName("John Smith");
        Location temp = new Location();
        temp.setCity("New York City");
        temp.setCountry("United States of America");
        this.setLocation(temp);
        Phone temp2 = new Phone();
        temp2.setNumber(initialPhoneNumber);
        this.setPhone(temp2);
        Phone temp3 = new Phone();
        temp3.setNumber(initialFaxNumber);
        this.setFax(temp2);
    }

    public String getCompanyName() {
        LOG.debug("returning the Company Name: " + this.myCompanyName);
        return this.myCompanyName;
    }

    @Override
    public int compareTo(Supplier other) {
        return this.getCompanyName().compareToIgnoreCase(other.getCompanyName());
    }

    public void setCompanyName(String companyName) {
        LOG.debug("setting the Company Name");
        int max = 40;
        if (companyName == null) {
            LOG.error("Company Name must not be null");
            throw new IllegalArgumentException("Company Name must not be null");
        }
        String safeCompanyName = this.mySanitizer.sanitizeInput(companyName);
        if (safeCompanyName.isEmpty()) {
            LOG.error("Company Name must not be empty");
            throw new IllegalArgumentException("Company Name must not be empty");
        }
        if (safeCompanyName.length() > 40) {
            LOG.error("Company Name must be up to 40 chars in length");
            throw new IllegalArgumentException("Company Name must be up to 40 chars in length");
        }
        LOG.debug("setting the First Name to: " + safeCompanyName);
        this.myCompanyName = safeCompanyName;
    }

    public String getContactName() {
        LOG.debug("returning the contactName: " + this.myContactName);
        return this.myContactName;
    }

    public void setContactName(String contactName) {
        LOG.debug("setting the ContactName");
        int max = 50;
        int min = 2;
        if (contactName == null) {
            LOG.debug("ContactName is set to null");
            this.myContactName = null;
            return;
        }
        String safeContactName = this.mySanitizer.sanitizeInput(contactName);
        if (safeContactName.isEmpty()) {
            LOG.error("ContactName must not be empty");
            throw new IllegalArgumentException("ContactName must not be empty");
        }
        if (safeContactName.length() > 50 || safeContactName.length() < 2) {
            LOG.error("ContactName must be between 2 and 40 chars in length");
            throw new IllegalArgumentException("ContactName must be between 2 and 40 chars in length");
        }
        LOG.debug("setting the ContactName to: " + safeContactName);
        this.myContactName = safeContactName;
    }

    public Location getLocation() {
        LOG.debug("returning the Location: " + String.valueOf(this.myLocation));
        return this.myLocation;
    }

    public void setLocation(Location location) {
        LOG.debug("setting the Location");
        if (location == null) {
            LOG.error("Location must not be null");
            throw new IllegalArgumentException("Location must not be null");
        }
        this.myLocation = location;
    }

    public Phone getPhone() {
        LOG.debug("returning the Phone: " + String.valueOf(this.myPhone));
        return this.myPhone;
    }

    public void setPhone(Phone phone) {
        LOG.debug("setting the Phone");
        this.myPhone = phone;
    }

    public Phone getFax() {
        LOG.debug("returning the Fax: " + String.valueOf(this.myPhone));
        return this.myFax;
    }

    public void setFax(Phone fax) {
        LOG.debug("setting the Fax");
        this.myFax = fax;
    }

    @Override
    public int hashCode() {
        LOG.debug("building HashCode");
        return new HashCodeBuilder().append(this.getId()).append((Object)this.myCompanyName).append((Object)this.myLocation.getCity()).append((Object)this.myLocation.getCountry()).append((Object)this.myPhone).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        LOG.debug("checking equals");
        if (obj instanceof Supplier) {
            Supplier other = (Supplier)obj;
            return new EqualsBuilder().append(this.getId(), other.getId()).append((Object)this.myCompanyName, (Object)other.myCompanyName).append((Object)this.myLocation.getCity(), (Object)other.myLocation.getCity()).append((Object)this.myLocation.getCountry(), (Object)other.myLocation.getCountry()).append((Object)this.myPhone, (Object)other.myPhone).isEquals();
        }
        return false;
    }

    @Override
    public String toString() {
        return "Supplier [Id=" + this.getId() + ", CompanyName=" + this.myCompanyName + ", City=" + this.myLocation.getCity() + ", Country=" + this.myLocation.getCountry() + ", Phone=" + this.myPhone.getNumber() + "]";
    }
}

