/*
 * Decompiled with CFR 0.152.
 */
package org.example.customer.utility;

import java.io.Serializable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.example.websecurity.XssSanitizer;
import org.example.websecurity.XssSanitizerImpl;

public class Phone
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger();
    private String myNumber;
    private XssSanitizer mySanitizer;

    public Phone() {
        this((XssSanitizer)new XssSanitizerImpl());
        LOG.debug("Finishing the default Constructor");
    }

    public Phone(XssSanitizer sanitizer) {
        LOG.debug("Starting the overloaded Constructor");
        String initialPhone = null;
        this.mySanitizer = sanitizer;
        this.setNumber(initialPhone);
    }

    public String getNumber() {
        LOG.debug("returning the Number: " + this.myNumber);
        return this.myNumber;
    }

    public void setNumber(String number) {
        LOG.debug("setting the Number");
        int max = 30;
        int min = 2;
        if (number == null) {
            LOG.debug("Number is set to null");
            this.myNumber = null;
            return;
        }
        String safeNumber = this.mySanitizer.sanitizeInput(number);
        if (safeNumber.isEmpty()) {
            LOG.error("Number must not be empty");
            throw new IllegalArgumentException("Number must not be empty");
        }
        if (safeNumber.length() > 30 || safeNumber.length() < 2) {
            LOG.error("Number must be between 2 and 40 chars in length");
            throw new IllegalArgumentException("Number must be between 2 and 20 chars in length");
        }
        LOG.debug("setting the Phone to: " + safeNumber);
        this.myNumber = safeNumber;
    }

    public int hashCode() {
        LOG.debug("building HashCode");
        return new HashCodeBuilder().append((Object)this.getNumber()).toHashCode();
    }

    public boolean equals(Object obj) {
        LOG.debug("checking equals");
        if (obj instanceof Phone) {
            Phone other = (Phone)obj;
            return new EqualsBuilder().append((Object)this.getNumber(), (Object)other.getNumber()).isEquals();
        }
        return false;
    }

    public String toString() {
        return "Phone [Number=" + this.myNumber + "]";
    }
}

