/*
 * Decompiled with CFR 0.152.
 */
package org.example.websecurity;

import java.io.Serializable;
import java.security.Principal;
import java.util.Arrays;
import java.util.Iterator;
import javax.security.auth.Subject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.example.websecurity.UserCredentials;

public final class UserCredentialsImpl
implements Serializable,
UserCredentials {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger();
    private Subject subject;

    public UserCredentialsImpl() {
        LOG.debug("Constructing a UserCredentials object.");
        this.subject = new Subject();
    }

    @Override
    public void addRole(String name) {
        LOG.debug("Adding a role: " + name);
        this.subject.getPrincipals().add(new PrincipalComponent(name));
    }

    @Override
    public String[] getRoles() {
        LOG.debug("Returning the Roles");
        PrincipalComponent[] principals = this.subject.getPrincipals().toArray(new PrincipalComponent[0]);
        String[] roles = new String[principals.length];
        for (int i = 0; i < roles.length; ++i) {
            roles[i] = principals[i].getName();
        }
        return roles;
    }

    @Override
    public boolean hasRole(String role) {
        LOG.debug("Checking if the role exists");
        return Arrays.asList(this.getRoles()).contains(role);
    }

    @Override
    public void removeRole(String role) {
        LOG.debug("Removing the role: " + role);
        if (!this.hasRole(role)) {
            LOG.error("Role is not found");
            throw new IllegalArgumentException("Role is not found");
        }
        Iterator<Principal> iterator = this.subject.getPrincipals().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getName().equals(role)) continue;
            iterator.remove();
            break;
        }
    }

    private class PrincipalComponent
    implements Serializable,
    Principal {
        private static final long serialVersionUID = 1L;
        private String name;

        PrincipalComponent(String nameValue) {
            LOG.debug("Constructing the Principal");
            if (nameValue == null) {
                LOG.error("Name is required");
                throw new IllegalArgumentException("Name must be provided");
            }
            this.name = nameValue;
        }

        @Override
        public String getName() {
            LOG.debug("Returning the Principal name: " + this.name);
            return this.name;
        }
    }
}

