/*
 * Decompiled with CFR 0.152.
 */
package org.example.websecurity;

import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.example.websecurity.XssSanitizer;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;

public class XssSanitizerImpl
implements XssSanitizer {
    private static final Logger LOG = LogManager.getLogger(XssSanitizerImpl.class);
    private Safelist rules = null;

    public XssSanitizerImpl() {
        LOG.debug("Starting constructor");
        Safelist defaultRules = Safelist.none();
        LOG.trace("Setting default rules to Safelist.none");
        this.setRules(defaultRules);
    }

    @Override
    public Safelist getRules() {
        LOG.debug("Returnung the current rules: " + this.rules.toString());
        return this.rules;
    }

    @Override
    public void setRules(Safelist rulesIn) {
        LOG.debug("Setting the rules");
        if (rulesIn == null) {
            LOG.error("Attempt to set the rules to null");
            throw new IllegalArgumentException("The rules must be provided");
        }
        LOG.trace("New rules are: " + rulesIn.toString());
        this.rules = rulesIn;
    }

    @Override
    public String sanitizeInput(String input) {
        LOG.debug("Sanitizing inout");
        if (input == null) {
            LOG.error("Attempt to sanitize null string");
            throw new IllegalArgumentException("Input required");
        }
        LOG.trace("Pre sanitized string: " + this.sanitizeOutput(input));
        String results = Jsoup.clean((String)input, (Safelist)this.rules);
        LOG.trace("Post sanitized string: " + results);
        return results.trim();
    }

    @Override
    public String sanitizeOutput(String input) {
        LOG.debug("Sanitizing output");
        if (input == null) {
            LOG.error("Attempt to sanitize null string");
            throw new IllegalArgumentException("Input required");
        }
        String temp = input.trim();
        return StringEscapeUtils.escapeHtml4((String)temp);
    }
}

