/*
 * Decompiled with CFR 0.152.
 */
package org.example.customer;

import java.io.Serializable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.example.customer.utility.CustomerEntity;
import org.example.customer.utility.Location;
import org.example.customer.utility.Phone;
import org.example.websecurity.XssSanitizer;
import org.example.websecurity.XssSanitizerImpl;

public final class Customer
extends CustomerEntity
implements Serializable,
Comparable<Customer> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger();
    private String myFirstName;
    private String myLastName;
    private Location myLocation;
    private Phone myPhone;
    private XssSanitizer mySanitizer;

    public Customer() {
        this((XssSanitizer)new XssSanitizerImpl());
        LOG.debug("Finishing the default Constructor");
    }

    public Customer(XssSanitizer sanitizer) {
        LOG.debug("Starting the overloaded Constructor");
        boolean initialId = true;
        String initialFirstName = "John";
        String initialLastName = "Smith";
        String initialNumber = null;
        this.mySanitizer = sanitizer;
        this.setId(1);
        this.setFirstName("John");
        this.setLastName("Smith");
        this.setLocation(new Location());
        Phone temp2 = new Phone();
        temp2.setNumber(initialNumber);
        this.setPhone(temp2);
    }

    @Override
    public int compareTo(Customer other) {
        String thisFullName = this.getFirstName() + " " + this.getLastName();
        String otherFullName = other.getFirstName() + " " + other.getLastName();
        return thisFullName.compareToIgnoreCase(otherFullName);
    }

    public String getFirstName() {
        LOG.debug("returning the First Name: " + this.myFirstName);
        return this.myFirstName;
    }

    public void setFirstName(String firstName) {
        LOG.debug("setting the First Name");
        int max = 40;
        if (firstName == null) {
            LOG.error("First Name must not be null");
            throw new IllegalArgumentException("First Name must not be null");
        }
        String safeFirstName = this.mySanitizer.sanitizeInput(firstName);
        if (safeFirstName.isEmpty()) {
            LOG.error("First Name must not be empty");
            throw new IllegalArgumentException("First Name must not be empty");
        }
        if (safeFirstName.length() > 40) {
            LOG.error("First Name must be up to 40 chars in length");
            throw new IllegalArgumentException("First Name must be up to 40 chars in length");
        }
        LOG.debug("setting the First Name to: " + safeFirstName);
        this.myFirstName = safeFirstName;
    }

    public String getLastName() {
        LOG.debug("returning the Last Name: " + this.myLastName);
        return this.myLastName;
    }

    public void setLastName(String lastName) {
        LOG.debug("setting the Last Name");
        int max = 40;
        int min = 2;
        if (lastName == null) {
            LOG.error("Last Name must not be null");
            throw new IllegalArgumentException("Last Name must not be null");
        }
        String safeLastName = this.mySanitizer.sanitizeInput(lastName);
        if (safeLastName.isEmpty()) {
            LOG.error("Last Name must not be empty");
            throw new IllegalArgumentException("Last Name must not be empty");
        }
        if (safeLastName.length() > 40 || safeLastName.length() < 2) {
            LOG.error("Last Name must be between 2 and 40 chars in length");
            throw new IllegalArgumentException("Last Name must be between 2 and 40 chars in length");
        }
        LOG.debug("setting the Last Name to: " + safeLastName);
        this.myLastName = safeLastName;
    }

    public Location getLocation() {
        LOG.debug("returning the Location: " + String.valueOf(this.myLocation));
        return this.myLocation;
    }

    public void setLocation(Location location) {
        LOG.debug("setting the Location");
        if (location == null) {
            LOG.error("Location must not be null");
            throw new IllegalArgumentException("Location must not be null");
        }
        this.myLocation = location;
    }

    public Phone getPhone() {
        LOG.debug("returning the Phone: " + String.valueOf(this.myPhone));
        return this.myPhone;
    }

    public void setPhone(Phone phone) {
        LOG.debug("setting the Phone");
        this.myPhone = phone;
    }

    @Override
    public int hashCode() {
        LOG.debug("building HashCode");
        return new HashCodeBuilder().append(this.getId()).append((Object)this.myFirstName).append((Object)this.myLastName).append(this.myLocation.hashCode()).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        LOG.debug("checking equals");
        if (obj instanceof Customer) {
            Customer other = (Customer)obj;
            return new EqualsBuilder().append(this.getId(), other.getId()).append((Object)this.myFirstName, (Object)other.myFirstName).append((Object)this.myLastName, (Object)other.myLastName).append((Object)this.myLocation.getCity(), (Object)other.myLocation.getCity()).append((Object)this.myLocation.getCountry(), (Object)other.myLocation.getCountry()).isEquals();
        }
        return false;
    }

    @Override
    public String toString() {
        return "Customer [Id=" + this.getId() + ", FirstName=" + this.myFirstName + ", LastName=" + this.myLastName + ", City=" + this.myLocation.getCity() + ", Country=" + this.myLocation.getCountry() + ", Phone=" + this.myPhone.getNumber() + "]";
    }
}

