/*
 * Decompiled with CFR 0.152.
 */
package org.example.customer;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.example.customer.OrderItem;
import org.example.customer.utility.CustomerEntity;
import org.example.websecurity.XssSanitizer;
import org.example.websecurity.XssSanitizerImpl;

public final class Order
extends CustomerEntity
implements Serializable,
Comparable<Order> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger();
    private LocalDate myOrderDate;
    private int myCustomerId;
    private double myTotalAmount;
    private String myOrderNumber;
    private XssSanitizer mySanitizer;
    private List<OrderItem> myOrderItems;

    public Order() {
        this((XssSanitizer)new XssSanitizerImpl());
        LOG.debug("Finishing the default Constructor");
    }

    public Order(XssSanitizer sanitizer) {
        LOG.debug("Starting the overloaded Constructor");
        boolean initialId = true;
        LocalDate initialOrderDate = LocalDate.now();
        boolean initialCustomerId = true;
        String initialOrderNumber = null;
        ArrayList<OrderItem> initalOrderItems = new ArrayList<OrderItem>();
        this.mySanitizer = sanitizer;
        this.setId(1);
        this.setOrderDate(initialOrderDate);
        this.setCustomerId(1);
        this.setOrderNumber(initialOrderNumber);
        this.setOrderItems(initalOrderItems);
    }

    @Override
    public int compareTo(Order other) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM-dd-yyyy");
        String thisSortValue = this.getOrderNumber() + " " + this.getOrderDate().format(formatter);
        String otherSortValue = other.getOrderNumber() + " " + other.getOrderDate().format(formatter);
        return thisSortValue.compareToIgnoreCase(otherSortValue);
    }

    public LocalDate getOrderDate() {
        LOG.debug("returning the Oder Date: " + String.valueOf(this.myOrderDate));
        return this.myOrderDate;
    }

    public void setOrderDate(LocalDate orderDate) {
        LOG.debug("setting the order Date");
        if (orderDate == null) {
            LOG.error("Order Date must not be null");
            throw new IllegalArgumentException("Order Date must not be null");
        }
        LocalDate tomorrow = LocalDate.now().plusDays(1L);
        if (!orderDate.isBefore(tomorrow)) {
            LOG.error("OrderDate must be today or earlier");
            throw new IllegalArgumentException("OrderDate must be today or earlier");
        }
        this.myOrderDate = orderDate;
    }

    public int getCustomerId() {
        LOG.debug("returning the CustomerId: " + this.myCustomerId);
        return this.myCustomerId;
    }

    public void setCustomerId(int customerId) {
        LOG.debug("setting the CustomerId: " + customerId);
        boolean min = true;
        if (customerId < 1) {
            LOG.error("CustomerId must be greater then zero");
            throw new IllegalArgumentException("CustomerId must be greater then zero");
        }
        this.myCustomerId = customerId;
    }

    public double getTotalAmount() {
        LOG.debug("returning the totalAmount: " + this.myTotalAmount);
        return this.myTotalAmount;
    }

    public void setTotalAmount(double totalAmount) {
        LOG.debug("setting the totalAmount: " + totalAmount);
        double min = 0.01;
        if (totalAmount < 0.01) {
            LOG.error("totalAmount must be greater then zero");
            throw new IllegalArgumentException("totalAmount must be greater then zero");
        }
        this.myTotalAmount = totalAmount;
    }

    public String getOrderNumber() {
        LOG.debug("returning the OrderNumber: " + this.myOrderNumber);
        return this.myOrderNumber;
    }

    public void setOrderNumber(String orderNumber) {
        LOG.debug("setting the OrderNumber");
        int max = 10;
        int min = 2;
        if (orderNumber == null) {
            LOG.debug("orderNumber is set to null");
            this.myOrderNumber = null;
            return;
        }
        String safeOrderNumber = this.mySanitizer.sanitizeInput(orderNumber);
        if (safeOrderNumber.isEmpty()) {
            LOG.error("OrderNumber must not be empty");
            throw new IllegalArgumentException("OrderNumber must not be empty");
        }
        if (safeOrderNumber.length() > 10 || safeOrderNumber.length() < 2) {
            LOG.error("OrderNumber must be between 2 and 10 chars in length");
            throw new IllegalArgumentException("OrderNumber must be between 2 and 10 chars in length");
        }
        LOG.debug("setting the OrderNumber to: " + safeOrderNumber);
        this.myOrderNumber = safeOrderNumber;
    }

    public List<OrderItem> getOrderItems() {
        LOG.debug("returning the OrderItems: " + String.valueOf(this.myOrderItems));
        return this.myOrderItems;
    }

    public void setOrderItems(List<OrderItem> orderItems) {
        LOG.debug("setting the Orderitems");
        if (orderItems == null) {
            LOG.error("Orderitems must not be null");
            throw new IllegalArgumentException("Orderitems must not be null");
        }
        double total = 0.0;
        for (OrderItem current : orderItems) {
            total += current.getSubTotal();
        }
        this.myTotalAmount = total;
        this.myOrderItems = orderItems;
    }

    @Override
    public int hashCode() {
        LOG.debug("building HashCode");
        return new HashCodeBuilder().append(this.getId()).append((Object)this.myOrderDate).append(this.myCustomerId).append((Object)this.myOrderNumber).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        LOG.debug("checking equals");
        if (obj instanceof Order) {
            Order other = (Order)obj;
            return new EqualsBuilder().append(this.getId(), other.getId()).append((Object)this.myOrderDate, (Object)other.myOrderDate).append(this.myCustomerId, other.myCustomerId).append((Object)this.myOrderNumber, (Object)other.myOrderNumber).isEquals();
        }
        return false;
    }

    @Override
    public String toString() {
        return "Order [Id=" + this.getId() + ", OrderDate=" + String.valueOf(this.myOrderDate) + ", CustomerId=" + this.myCustomerId + ", TotalAmount=" + this.myTotalAmount + ", OrderNumber=" + this.myOrderNumber + ", OrderItems=" + this.myOrderItems.size() + "]";
    }
}

