/*
 * Decompiled with CFR 0.152.
 */
package org.example.customer;

import java.io.Serializable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.example.customer.utility.CustomerEntity;

public final class OrderItem
extends CustomerEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger();
    private int myOrderId;
    private int myProductId;
    private double myUnitPrice;
    private int myQuantity;
    private double mySubTotal;

    public OrderItem() {
        LOG.debug("Starting the default Constructor");
        boolean initialId = true;
        boolean initialOrderId = true;
        boolean initialProductId = true;
        double initialUnitPrice = 0.01;
        boolean initialQuantity = true;
        this.setId(1);
        this.setOrderId(1);
        this.setProductId(1);
        this.setUnitPrice(0.01);
        this.setQuantity(1);
        this.computeSubTotal();
    }

    private void computeSubTotal() {
        LOG.debug("Computing the subTotal");
        this.mySubTotal = (double)this.myQuantity * this.myUnitPrice;
    }

    public int getOrderId() {
        LOG.debug("returning the OrderId: " + this.myOrderId);
        return this.myOrderId;
    }

    public void setOrderId(int orderId) {
        LOG.debug("setting the OrderId: " + orderId);
        boolean min = true;
        if (orderId < 1) {
            LOG.error("OrderId must be greater then zero");
            throw new IllegalArgumentException("OrderId must be greater then zero");
        }
        this.myOrderId = orderId;
    }

    public int getProductId() {
        LOG.debug("returning the ProductId: " + this.myProductId);
        return this.myProductId;
    }

    public void setProductId(int productId) {
        LOG.debug("setting the productId: " + productId);
        boolean min = true;
        if (productId < 1) {
            LOG.error("productId must be greater then zero");
            throw new IllegalArgumentException("productId must be greater then zero");
        }
        this.myProductId = productId;
    }

    public double getUnitPrice() {
        LOG.debug("returning the UnitPrice: " + this.myUnitPrice);
        return this.myUnitPrice;
    }

    public void setUnitPrice(double unitPrice) {
        LOG.debug("setting the unitPrice: " + unitPrice);
        double min = 0.01;
        if (unitPrice < 0.01) {
            LOG.error("unitPrice must be greater then zero");
            throw new IllegalArgumentException("unitPrice must be greater then zero");
        }
        this.myUnitPrice = unitPrice;
        this.computeSubTotal();
    }

    public int getQuantity() {
        LOG.debug("returning the Quantity: " + this.myQuantity);
        return this.myQuantity;
    }

    public void setQuantity(int quantity) {
        LOG.debug("setting the Quantity: " + quantity);
        boolean min = true;
        if (quantity < 1) {
            LOG.error("Quantity must be greater then zero");
            throw new IllegalArgumentException("Quantity must be greater then zero");
        }
        this.myQuantity = quantity;
        this.computeSubTotal();
    }

    public double getSubTotal() {
        LOG.debug("returning the SubTotal: " + this.mySubTotal);
        return this.mySubTotal;
    }

    @Override
    public int hashCode() {
        LOG.debug("building HashCode");
        return new HashCodeBuilder().append(this.getId()).append(this.myOrderId).append(this.myProductId).append(this.myUnitPrice).append(this.myQuantity).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        LOG.debug("checking equals");
        if (obj instanceof OrderItem) {
            OrderItem other = (OrderItem)obj;
            return new EqualsBuilder().append(this.getId(), other.getId()).append(this.myOrderId, other.myOrderId).append(this.myProductId, other.myProductId).append(this.myUnitPrice, other.myUnitPrice).append(this.myQuantity, other.myQuantity).isEquals();
        }
        return false;
    }

    @Override
    public String toString() {
        return "OrderItem [Id=" + this.getId() + ", OrderId=" + this.myOrderId + ", ProductId=" + this.myProductId + ", UnitPrice=" + this.myUnitPrice + ", Quantity=" + this.myQuantity + ", SubTotal=" + this.mySubTotal + "]";
    }
}

