/*
 * Decompiled with CFR 0.152.
 */
package org.example.customer.utility;

import java.io.Serializable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.example.websecurity.XssSanitizer;
import org.example.websecurity.XssSanitizerImpl;

public class Location
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger();
    private String myCity;
    private String myCountry;
    private XssSanitizer mySanitizer;

    public Location() {
        this((XssSanitizer)new XssSanitizerImpl());
        LOG.debug("Finishing the default Constructor");
    }

    public Location(XssSanitizer sanitizer) {
        LOG.debug("Starting the overloaded Constructor");
        String initialCity = "New York City";
        String initialCountry = "United States of America";
        this.mySanitizer = sanitizer;
        this.setCity("New York City");
        this.setCountry("United States of America");
    }

    public String getCity() {
        LOG.debug("returning the City: " + this.myCity);
        return this.myCity;
    }

    public void setCity(String city) {
        LOG.debug("setting the City");
        int max = 40;
        int min = 2;
        if (city == null) {
            LOG.debug("City is set to null");
            this.myCity = null;
            return;
        }
        String safeCity = this.mySanitizer.sanitizeInput(city);
        if (safeCity.isEmpty()) {
            LOG.error("City must not be empty");
            throw new IllegalArgumentException("City must not be empty");
        }
        if (safeCity.length() > 40 || safeCity.length() < 2) {
            LOG.error("City must be between 2 and 40 chars in length");
            throw new IllegalArgumentException("City must be between 2 and 40 chars in length");
        }
        LOG.debug("setting the City to: " + safeCity);
        this.myCity = safeCity;
    }

    public String getCountry() {
        LOG.debug("returning the Country: " + this.myCountry);
        return this.myCountry;
    }

    public void setCountry(String country) {
        LOG.debug("setting the Country");
        int max = 40;
        int min = 2;
        if (country == null) {
            LOG.debug("Country is set to null");
            this.myCountry = null;
            return;
        }
        String safeCountry = this.mySanitizer.sanitizeInput(country);
        if (safeCountry.isEmpty()) {
            LOG.error("Country must not be empty");
            throw new IllegalArgumentException("Country must not be empty");
        }
        if (safeCountry.length() > 40 || safeCountry.length() < 2) {
            LOG.error("Country must be between 2 and 40 chars in length");
            throw new IllegalArgumentException("Country must be between 2 and 40 chars in length");
        }
        LOG.debug("setting the Country to: " + safeCountry);
        this.myCountry = safeCountry;
    }

    public int hashCode() {
        LOG.debug("building HashCode");
        return new HashCodeBuilder().append((Object)this.getCity()).append((Object)this.getCountry()).toHashCode();
    }

    public boolean equals(Object obj) {
        LOG.debug("checking equals");
        if (obj instanceof Location) {
            Location other = (Location)obj;
            return new EqualsBuilder().append((Object)this.getCity(), (Object)other.getCity()).append((Object)this.getCountry(), (Object)other.getCountry()).isEquals();
        }
        return false;
    }

    public String toString() {
        return "Location [City=" + this.myCity + ", Country=" + this.myCountry + "]";
    }
}

