package org.example.customer.utility;

/*
 * This is free and unencumbered software released into the public domain.
 * Anyone is free to copy, modify, publish, use, compile, sell, or distribute this software, 
 * either in source code form or as a compiled binary, for any purpose, commercial or 
 * non-commercial, and by any means.
 * 
 * In jurisdictions that recognize copyright laws, the author or authors of this 
 * software dedicate any and all copyright interest in the software to the public domain. 
 * We make this dedication for the benefit of the public at large and to the detriment of 
 * our heirs and successors. We intend this dedication to be an overt act of relinquishment in 
 * perpetuity of all present and future rights to this software under copyright law.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
 * PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES 
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,  
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * For more information, please refer to: https://unlicense.org/
*/

import java.io.Serializable;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * The Customer Entity for the Customer application.
 <br>
 <br>
 * This class represents the common Id field in the Customer Database
 *
 * @author Jonathan Earl
 * @version 1.0
 *
 */
public class CustomerEntity
    implements Serializable
{
    private static final long serialVersionUID = 1L;
    
    private static final Logger LOG = LogManager.getLogger();
    
    private int myId;
    
    /**
     * The default constructor for the CustomerEntity class.
     * <p>
     * The initial values are:
     * <ul>
     *   <li>id: 1</li>
     * </ul>
     * 
     */
    public CustomerEntity()
    {
        LOG.debug("Starting the default Constructor");
        final int initialId = 1;
        
        setId(initialId);
    }
    
    /**
     * Returns the id value for the Customer.
     *  
     * @return the id value for the customer
     */
    public int getId()
    {
        LOG.debug("returning the Id: " + myId);
        return myId;
    }

    /**
     * Sets the id value for the Customer.
     * <p>
     * The business rules are:
     * <ul>
     *   <li>the id must be 1 or greater</li>
     * </ul>
     * 
     * @param id the value to set into the customer id field
     * @throws IllegalArgumentException if the id is invalid
     */
    public void setId(final int id)
    {
        LOG.debug("setting the Id: " + id);
        final int min = 1;
        
        if (id < min)
        {
            LOG.error("Id must be greater then zero");
            throw new IllegalArgumentException("Id must be greater then zero");
        }
        this.myId = id;
    }
    
    /**
     * The hashCode() method of the CustomerEntity class.
     * <p>
     * <strong>This method uses:</strong>
     * <ul>
     *  <li>id</li>
     * </ul>
     * 
     * @see java.lang.Object#hashCode()
     * @return the hashCode value for this CustomerEntity object
     */
    @Override
    public int hashCode()
    {
        LOG.debug("building HashCode");
        return new HashCodeBuilder()
                .append(getId())
                .toHashCode();
    }

    /**
     * The equals() method of the CustomerEntity class.
     * <p>
     * <strong>This method uses:</strong>
     * <ul>
     *  <li>id</li>
     * </ul>
     * 
     * @see java.lang.Object#equals(Object obj)
     * @param obj the incoming object to compare against
     * @return true if the fields being compared are equal
     */
    @Override
    public boolean equals(final Object obj)
    {
        LOG.debug("checking equals");
        if (obj instanceof CustomerEntity)
        {
            final CustomerEntity other = (CustomerEntity) obj;
            return new EqualsBuilder()
                    .append(getId(), other.getId())
                    .isEquals();
        }
        else
        {
            return false;
        }
    }

    /**
     * The toString method for the CustomerEntity class.
     * 
     * this method will return:<br>
     * CustomerEntity [Id=xxx]
     */
    @Override
    public String toString()
    {
        return "CustomerEntity [Id=" + getId() + "]";
    }
}
