package org.example.customer;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.config.Configurator;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;


public class OrderItemTest
{
    private OrderItem testOrderItem = null;
    
    @BeforeClass // this runs only once before any test
    public static void setup()
    {
        Configurator.setLevel(LogManager.getLogger(OrderItem.class).getName(), Level.WARN);
    }
    
    @Before
    public void setUp() throws Exception
    {
        testOrderItem = new OrderItem();
    }
    
    @Test
    public void testOrderDefaultConstructor()
    {
        OrderItem defaultOrderItem = new OrderItem();
        assertNotNull(defaultOrderItem);
    }
        
    @Test
    public void testDefaultOrderId()
    {
        int expected = 1;
        int actual = testOrderItem.getOrderId();
        assertEquals(expected, actual);
    }

    @Test
    public void testValidOrderId()
    {
        int[] good = { 2, 34, 999, 22, 1, 565656 };
        for (int entry : good) {
            testOrderItem.setOrderId(entry);
        }
    }

    @Test(expected = IllegalArgumentException.class)
    public void testInValidOrderId()
    {
        testOrderItem.setOrderId(0);
    }
    
    @Test
    public void testDefaultProductId()
    {
        int expected = 1;
        int actual = testOrderItem.getProductId();
        assertEquals(expected, actual);
    }

    @Test
    public void testValidProductId()
    {
        int[] good = { 2, 34, 999, 22, 1, 565656 };
        for (int entry : good) {
            testOrderItem.setProductId(entry);
        }
    }

    @Test(expected = IllegalArgumentException.class)
    public void testInValidProductId()
    {
        testOrderItem.setProductId(0);
    }
    
    @Test
    public void testDefaultUnitPrice()
    {
        double expected = 0.01;
        double actual = testOrderItem.getUnitPrice();
        double precision = 0.001;
        assertEquals(expected, actual, precision);
    }

    @Test
    public void testValidUnitPrice()
    {
        double[] good = {2.0, 0.34, 999.50, 22.25, 1.0};
        for (double entry : good) {
            testOrderItem.setUnitPrice(entry);
        }
    }

    @Test(expected = IllegalArgumentException.class)
    public void testInValidUnitPrice()
    {
        testOrderItem.setUnitPrice(0.0);
    }
    
    @Test
    public void testDefaultQuantity()
    {
        int expected = 1;
        int actual = testOrderItem.getQuantity();
        assertEquals(expected, actual);
    }

    @Test
    public void testValidQuantity()
    {
        int[] good = { 2, 34, 999, 22, 1, 565656 };
        for (int entry : good) {
            testOrderItem.setQuantity(entry);
        }
    }

    @Test(expected = IllegalArgumentException.class)
    public void testInValidQuantity()
    {
        testOrderItem.setQuantity(0);
    }
    
    @Test
    public void testDefaultSubTotal()
    {
        double expected = 0.01;
        double actual = testOrderItem.getSubTotal();
        double precision = 0.001;
        assertEquals(expected, actual, precision);
    }

    @Test
    public void testChangedSubTotal()
    {
        testOrderItem.setQuantity(23);
        testOrderItem.setUnitPrice(5.55);
        
        double expected = 23 * 5.55;
        double actual = testOrderItem.getSubTotal();
        double precision = 0.001;
        assertEquals(expected, actual, precision);
    }
    
    @Test  
    public void testToString()
    {
        String expected = "OrderItem [Id=1, "
                + "OrderId=1, ProductId=1, "
                + "UnitPrice=0.01, Quantity=1, "
                + "SubTotal=0.01]";
        String actual = testOrderItem.toString();
        assertEquals(expected, actual);
    }
    
    @Test public void testHashCode()
    {
        OrderItem sample = new OrderItem();
        int expected = sample.hashCode();
        int actual = testOrderItem.hashCode();
        assertEquals(expected, actual);
    }
    
    @Test public void testEquals()
    {
        OrderItem sample = new OrderItem();
        assertTrue(testOrderItem.equals(sample));
    }
    
    @Test public void testNotEquals()
    {
        OrderItem sample = new OrderItem();
        sample.setOrderId(2);
        assertFalse(testOrderItem.equals(sample));
        
        Order junk = new Order();
        assertFalse(testOrderItem.equals(junk));
    }

}
