package org.example.customer.utility;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.config.Configurator;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class CustomerEntityTest
{
    private CustomerEntity testCustomerEntity = null;
   
    @BeforeClass // this runs only once before any test
    public static void setup()
    {
        Configurator.setLevel(LogManager.getLogger(CustomerEntity.class).getName(), Level.WARN);
    }

    @Before
    public void setUp() throws Exception
    {
        testCustomerEntity = new CustomerEntity();
    }
    
    @Test
    public void testCustomerEntityDefaultConstructor()
    {
        CustomerEntity defaultCustomerEntity = new CustomerEntity();
        assertNotNull(defaultCustomerEntity);
    }
    
    @Test
    public void testDefaultId()
    {
        int expected = 1;
        int actual = testCustomerEntity.getId();
        assertEquals(expected, actual);
    }

    @Test
    public void testValidId()
    {
        int[] good = { 2, 34, 999, 22, 1, 565656 };
        for (int entry : good) 
        {
            testCustomerEntity.setId(entry);
        }
    }

    @Test(expected = IllegalArgumentException.class)
    public void testInValidId()
    {
        testCustomerEntity.setId(0);
    }

    @Test  
    public void testToString()
    {
        String expected = "CustomerEntity [Id=1]";
        String actual = testCustomerEntity.toString();
        assertEquals(expected, actual);
    }
    
    @Test public void testHashCode()
    {
        CustomerEntity sample = new CustomerEntity();
        int expected = sample.hashCode();
        int actual = testCustomerEntity.hashCode();
        assertEquals(expected, actual);
    }
    
    @Test public void testEquals()
    {
        CustomerEntity sample = new CustomerEntity();
        assertTrue(testCustomerEntity.equals(sample));
    }
    
    @Test public void testNotEquals()
    {
        CustomerEntity sample = new CustomerEntity();
        sample.setId(42);
        assertFalse(testCustomerEntity.equals(sample));
        
        Object junk = new Object();
        assertFalse(testCustomerEntity.equals(junk));
    }
}
