package org.example.customerdao.utility;

/*
 * This is free and unencumbered software released into the public domain.
 * Anyone is free to copy, modify, publish, use, compile, sell, or distribute this software, 
 * either in source code form or as a compiled binary, for any purpose, commercial or 
 * non-commercial, and by any means.
 * 
 * In jurisdictions that recognize copyright laws, the author or authors of this 
 * software dedicate any and all copyright interest in the software to the public domain. 
 * We make this dedication for the benefit of the public at large and to the detriment of 
 * our heirs and successors. We intend this dedication to be an overt act of relinquishment in 
 * perpetuity of all present and future rights to this software under copyright law.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
 * PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES 
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,  
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * For more information, please refer to: https://unlicense.org/
*/

import java.io.Serializable;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 * The NonDeleteableRecordException class for the <strong>CustomerDAO</strong>.
 *
 * @author Jonathan Earl
 * @version 1.0
 *
 */
public final class NonDeleteableRecordException extends RuntimeException
   implements Serializable
{
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LogManager.getLogger();

    /**
     * Default Constructor.
     * 
     * Sets the message to "Unknown Service Error"
     */
    public NonDeleteableRecordException()
    {
        super("Record is not deleteable");
        LOG.error("Record is not deleteable");
    }

    /**
     * Constructor.
     * 
     * @param message the message to set
     * @see NonDeleteableRecordException#NonDeleteableRecordException()
     */
    public NonDeleteableRecordException(final String message)
    {
        super(message);
        LOG.error(message);
    }

    /**
     * Throwable Constructor.
     * 
     * @param message the message to set
     * @param cause the inner exception
     * @see NonDeleteableRecordException#NonDeleteableRecordException()
     * @see NonDeleteableRecordException#NonDeleteableRecordException(String message)
     */
    public NonDeleteableRecordException(final String message, final Throwable cause)
    {
        super(message, cause);
        LOG.error(message + " - " + cause.getLocalizedMessage());
    }

    /**
     * Throwable Constructor.
     * 
     * @param cause the inner exception
     * @see NonDeleteableRecordException#NonDeleteableRecordException()
     * @see NonDeleteableRecordException#NonDeleteableRecordException(String message)
     * @see NonDeleteableRecordException#NonDeleteableRecordException(String message, Throwable cause)
     */
    public NonDeleteableRecordException(final Throwable cause)
    {
        super(cause);
        LOG.error(cause.getLocalizedMessage());
    }
}
