package org.example.customerdao.utility;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNotNull;

import org.junit.jupiter.api.Test;

public class TestNonDeleteableRecordException
{
    @Test
    public void testDefaultConstructor() {

        NonDeleteableRecordException result = new NonDeleteableRecordException();

        assertNotNull(result);
        assertEquals(null, result.getCause());
        assertEquals(
                "org.example.customerdao.utility.NonDeleteableRecordException: " + 
                "Record is not deleteable", result.toString());
        assertEquals(
                "Record is not deleteable", result.getMessage());
        assertEquals(
                "Record is not deleteable", result.getLocalizedMessage());
    }

    @Test
    public void testStringConstructor() {
        
        String message = "Dummy Message";

        NonDeleteableRecordException result = 
                new NonDeleteableRecordException(message);

        assertNotNull(result);
        assertEquals(null, result.getCause());
        assertEquals(
           "org.example.customerdao.utility.NonDeleteableRecordException: " + 
           "Dummy Message", result.toString());
        assertEquals("Dummy Message", result.getMessage());
        assertEquals("Dummy Message", result.getLocalizedMessage());
    }

    @Test
    public void testThrowableConstructor() {
        
        Throwable cause = new Throwable();

        NonDeleteableRecordException result = 
                new NonDeleteableRecordException(cause);

        assertNotNull(result);
        assertEquals(
           "org.example.customerdao.utility.NonDeleteableRecordException: " + 
           "java.lang.Throwable", result.toString());
        assertEquals("java.lang.Throwable", result.getMessage());
        assertEquals("java.lang.Throwable", result.getLocalizedMessage());
    }

    @Test
    public void testStringThrowableConstructor() {
        
        String message = "Dummy Message";
        Throwable cause = new Throwable();

        NonDeleteableRecordException result = 
                new NonDeleteableRecordException(message, cause);

        assertNotNull(result);
        assertEquals(
           "org.example.customerdao.utility.NonDeleteableRecordException: " + 
           "Dummy Message", result.toString());
        assertEquals("Dummy Message", result.getMessage());
        assertEquals("Dummy Message", result.getLocalizedMessage());
    }
}
