DROP VIEW COUNT_PRODUCT_ORDERS
DROP TABLE ORDER_ITEM
DROP TABLE ORDERS
DROP TABLE PRODUCT
DROP TABLE SUPPLIER
DROP TABLE CUSTOMER
CREATE TABLE CUSTOMER (ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1),FIRST_NAME VARCHAR(40) NOT NULL,LAST_NAME VARCHAR(40) NOT NULL,CITY VARCHAR(40),COUNTRY VARCHAR(40),PHONE VARCHAR(20),CONSTRAINT PK_CUSTOMER PRIMARY KEY (ID))
CREATE TABLE ORDERS (ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1),ORDER_DATE DATE NOT NULL,CUSTOMER_ID  INTEGER,TOTAL_AMOUNT DECIMAL(12,2),ORDER_NUMBER VARCHAR(10),CONSTRAINT PK_ORDER PRIMARY KEY (ID)) 
CREATE TABLE ORDER_ITEM (ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1),ORDER_ID INTEGER NOT NULL,PRODUCT_ID INTEGER NOT NULL,UNIT_PRICE DECIMAL(12,2) NOT NULL,QUANTITY INTEGER NOT NULL,CONSTRAINT PK_ORDERITEM PRIMARY KEY (ID))
CREATE TABLE PRODUCT (ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1),PRODUCT_NAME VARCHAR(50) NOT NULL,SUPPLIER_ID INTEGER NOT NULL,UNIT_PRICE DECIMAL(12,2),PACKAGE  VARCHAR(30),IS_DISCONTINUED BOOLEAN,CONSTRAINT PK_PRODUCT PRIMARY KEY (ID))
CREATE TABLE SUPPLIER (ID INTEGER NOT NULL GENERATED BY DEFAULT AS IDENTITY (START WITH 1),COMPANY_NAME VARCHAR(40) NOT NULL,CONTACT_NAME VARCHAR(50),CITY VARCHAR(40),COUNTRY VARCHAR(40),PHONE VARCHAR(30),FAX VARCHAR(30),CONSTRAINT PK_SUPPLIER PRIMARY KEY (ID))
CREATE VIEW COUNT_PRODUCT_ORDERS AS SELECT oi.quantity AS quantity, p.product_name FROM (SELECT sum(quantity) AS quantity, product_id FROM order_item GROUP BY product_id) AS oi INNER JOIN product P ON oi.product_id = p.id UNION SELECT 0 AS quantity, p.product_name FROM product P WHERE p.id NOT IN (SELECT DISTINCT product_id FROM order_item) ORDER BY quantity