package org.example.rest;

import java.util.List;

import javax.sql.DataSource;

import org.example.customer.Customer;
import org.example.customerdao.CustomerDAO;
import org.example.customerdao.CustomerDAOImpl;
import org.example.training.web.service.CredentialsManager;
import org.example.training.web.service.ResourceManager;
import org.example.websecurity.UserCredentials;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;

@Path("customer")
public class CustomerEndpoint {
	
	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("findAll")
	public Response findAll(@HeaderParam("Bearer") String token) throws Exception {
	
		CredentialsManager credManager = new CredentialsManager();
		UserCredentials creds = null;
		try 
		{
			creds = credManager.getCredentials(token);
		} 
		catch (IllegalArgumentException e) 
		{
			throw new RESTException(e.getMessage());
		}
		

		CustomerDAO customerDAO = new CustomerDAOImpl();
		DataSource ds = ResourceManager.INSTANCE.getDataSource();
		customerDAO.setReadOnlyDS(ds);
		
		try 
		{
			List<Customer> data = customerDAO.findAllCustomers(creds);
			return Response.status(Response.Status.OK)
		        	.entity(data)
		        	.type(MediaType.APPLICATION_JSON)
		        	.build();
		} 
		catch (Exception e) 
		{
			throw new RESTException(e.getMessage());
		}		
	}
	
	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("findById/{id}")
	public Response findById(@HeaderParam("Bearer") String token, @PathParam("id") int id) 
			throws Exception {
	
		CredentialsManager credManager = new CredentialsManager();
		UserCredentials creds = null;
		try 
		{
			creds = credManager.getCredentials(token);
		} 
		catch (Exception e) 
		{
			throw new RESTException(e.getMessage());
		}
		

		CustomerDAO customerDAO = new CustomerDAOImpl();
		DataSource ds = ResourceManager.INSTANCE.getDataSource();
		customerDAO.setReadOnlyDS(ds);
		
		try 
		{
			Customer data = customerDAO.findCustomerById(creds, id);
			return Response.status(Response.Status.OK)
				.entity(data)
				.type(MediaType.APPLICATION_JSON)
				.build();
		} 
		catch (Exception e) 
		{
			throw new RESTException(e.getMessage());
		}
	}
	
	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("create")
	public Response create(@HeaderParam("Bearer") String token, Customer customer) 
			throws Exception {
		
		CredentialsManager credManager = new CredentialsManager();
		UserCredentials creds = null;
		try 
		{
			creds = credManager.getCredentials(token);
		} 
		catch (Exception e) 
		{
			throw new RESTException(e.getMessage());
		}
		

		CustomerDAO customerDAO = new CustomerDAOImpl();
		DataSource ds = ResourceManager.INSTANCE.getDataSource();
		customerDAO.setReadWriteDS(ds);
		customerDAO.setReadOnlyDS(ds);
		
		try 
		{
			int newId = customerDAO.addCustomer(creds, customer);
			
			return Response.status(Response.Status.OK)
			    	.entity("Customer added, new Id is: " + newId)
			    	.type(MediaType.APPLICATION_JSON)
			    	.build();
		} 
		catch (Exception e) 
		{
			throw new RESTException(e.getMessage());
		}
	}
	
	@PUT
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("update")
	public Response update(@HeaderParam("Bearer") String token, Customer customer) 
			throws Exception {
	
		CredentialsManager credManager = new CredentialsManager();
		UserCredentials creds = null;
		try 
		{
			creds = credManager.getCredentials(token);
		} 
		catch (Exception e) 
		{
			throw new RESTException(e.getMessage());
		}
		

		CustomerDAO customerDAO = new CustomerDAOImpl();
		DataSource ds = ResourceManager.INSTANCE.getDataSource();
		customerDAO.setReadWriteDS(ds);
		customerDAO.setReadOnlyDS(ds);
		
		try 
		{
			customerDAO.updateCustomer(creds, customer);
			
			return Response.status(Response.Status.OK)
			    	.entity("Customer " + customer.getId() + "updated")
			    	.type(MediaType.APPLICATION_JSON)
			    	.build();
		} 
		catch (Exception e) 
		{
			throw new RESTException(e.getMessage());
		}
	}
	
	@DELETE
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("delete/{id}")
	public Response delete(@HeaderParam("Bearer") String token, @PathParam("id") int id) 
			throws Exception {
	
		CredentialsManager credManager = new CredentialsManager();
		UserCredentials creds = null;
		try 
		{
			creds = credManager.getCredentials(token);
		} 
		catch (Exception e) 
		{
			throw new RESTException(e.getMessage());
		}
		

		CustomerDAO customerDAO = new CustomerDAOImpl();
		DataSource ds = ResourceManager.INSTANCE.getDataSource();
		customerDAO.setReadWriteDS(ds);
		customerDAO.setReadOnlyDS(ds);
		
		try 
		{
			customerDAO.deleteEntity(creds, id);
			
			return Response.status(Response.Status.OK)
			    	.entity("Customer " + id + " deleted")
			    	.type(MediaType.APPLICATION_JSON)
			    	.build();
		} 
		catch (Exception e) 
		{
			throw new RESTException(e.getMessage());
		}
	}
	
}
