package org.example.training.web.service;

import java.io.Serializable;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

import org.example.websecurity.UserCredentials;
import org.example.websecurity.UserCredentialsImpl;
import org.json.JSONException;
import org.json.JSONObject;



public class CredentialsManager implements Serializable {
	private static final long serialVersionUID = 1L;

	private UserCredentials creds = new UserCredentialsImpl();
	String authURL = "http://172.16.0.51:8080/auth_service/api/auth/verify";
	String jsonMimeType = "application/json";


	public UserCredentials getCredentials(String inData) throws Exception {
		
		HttpRequest request;
		HttpClient client;
		HttpResponse<String> response;
		
		
		JSONObject authJson = new JSONObject();
		authJson.put("token", inData);

		

		request = HttpRequest.newBuilder()
				.uri(URI.create(authURL))
				.POST(HttpRequest.BodyPublishers.ofString(authJson.toString()))
				.setHeader("Content-Type", jsonMimeType)
				.setHeader("Accept", jsonMimeType)
				.build();
		
		client = HttpClient.newHttpClient();
		response = client.send(request, HttpResponse.BodyHandlers.ofString());

		
		JSONObject details = new JSONObject(response.body());
		String title;
		try 
		{
			title = details.getString("title");
		} 
		catch (JSONException e) 
		{
			throw new IllegalArgumentException("invalid authorization token");
		}
		if ( title.equals("Manager")) {
			creds.addRole("manager");
			creds.addRole("worker");
			creds.addRole("guest");
		}
		else if (title.equals("Aide") || title.equals("Sales Agent") || title.equals("Developer")) {
			creds.addRole("worker");
			creds.addRole("guest");
		}
		else {
			creds.addRole("guest");
		}
		return creds;
	}
}
