package org.example.websecurity;

/*
 * This is free and unencumbered software released into the public domain.
 * Anyone is free to copy, modify, publish, use, compile, sell, or distribute this software, 
 * either in source code form or as a compiled binary, for any purpose, commercial or 
 * non-commercial, and by any means.
 * 
 * In jurisdictions that recognize copyright laws, the author or authors of this 
 * software dedicate any and all copyright interest in the software to the public domain. 
 * We make this dedication for the benefit of the public at large and to the detriment of 
 * our heirs and successors. We intend this dedication to be an overt act of relinquishment in 
 * perpetuity of all present and future rights to this software under copyright law.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
 * PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES 
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,  
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * For more information, please refer to: https://unlicense.org/
*/

/** this is the primary Interface for handling User Credentials.
 * 
 * @author Jonathan Earl
 * @version 1.0
 *
 */
public interface UserCredentials
{
    /**
     * This will add a Role to the UserCredentials.
     * 
     * @param name the role to place into the Subject
     */
    void addRole(String name);
    
    /**
     * This will remove a Role to the UserCredentials.
     * 
     * 
     * @param name the role to place into the Subject
     * @throws IllegalArgumentException is the Role is not found
     */
    void removeRole(String name);

    /**
     * Return the String[] containing the roles for this UserCredentials.
     * 
     * @return String[] holding the roles for this User
     */
    String[] getRoles();
    
    /**
     * Check is a specific Role is in the list of Roles for this UserCredentials.
     * 
     * @param role the Role to check
     * @return true if Role is in the list of Roles
     */
    boolean hasRole(String role);

}
