package org.example.websecurity;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.jupiter.api.Assertions.assertThrows;

import java.util.Arrays;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class UserCredentialsTest
{
    private UserCredentialsImpl testUserCredentials;

    @BeforeEach
    public void setUp() throws Exception
    {
        testUserCredentials = new UserCredentialsImpl();
    }

    @Test
    public void testDefaultConstructor()
    {
        UserCredentialsImpl defaultUserCredentials = new UserCredentialsImpl();
        assertNotNull(defaultUserCredentials);
    }
    
    @Test
    public void testAddingRole()
    {
        String role = "Manager";
        testUserCredentials.addRole(role);
        
        String[] roles = testUserCredentials.getRoles();
        assertTrue(roles.length == 1);
        assertTrue(Arrays.asList(roles).contains(role));
    }
    
    @Test
    public void testDoesNotHaveRole()
    {
        String role = "Manager";
        testUserCredentials.addRole(role);
       
        assertFalse(testUserCredentials.hasRole("Clerk"));
    }
    
    @Test 
    public void testNullRole()
    {
        assertThrows(IllegalArgumentException.class, () ->
            testUserCredentials.addRole(null));
    }
    
    @Test 
    public void testRemoveValidRole()
    {
        String role1 = "Manager";
        testUserCredentials.addRole(role1);
        
        String role2 = "Clerk";
        testUserCredentials.addRole(role2);
        
        String role3 = "Guest";
        testUserCredentials.addRole(role3);
        
        String[] roles = testUserCredentials.getRoles();
        assertTrue(roles.length == 3);
        assertTrue(Arrays.asList(roles).contains(role1));
        assertTrue(Arrays.asList(roles).contains(role2));
        assertTrue(Arrays.asList(roles).contains(role3));
        
        testUserCredentials.removeRole(role2);
        roles = testUserCredentials.getRoles();
        assertTrue(roles.length == 2);
        assertTrue(Arrays.asList(roles).contains(role1));
        assertTrue(! Arrays.asList(roles).contains(role2));
        assertTrue(Arrays.asList(roles).contains(role3));
    }
    
    @Test 
    public void testRemovingInvalidRole()
    {
        String role1 = "Manager";
        testUserCredentials.addRole(role1);
        
        String role2 = "Clerk";
        testUserCredentials.addRole(role2);
        
        String role3 = "Guest";
        
        assertThrows(IllegalArgumentException.class, () ->
            testUserCredentials.removeRole(role3));
    }
   
}
