package org.example.websecurity;

import static org.junit.jupiter.api.Assertions.assertThrows;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

import io.github.netmikey.logunit.api.LogCapturer;

public class XssSanitizerLoggingTest {

	@RegisterExtension
	LogCapturer logs = LogCapturer.create()
		.captureForType(XssSanitizerImpl.class, org.slf4j.event.Level.TRACE);

	@Test
	public void testConstructorLogging() {
		new XssSanitizerImpl();
		logs.assertContains("Starting constructor");
	}

	@Test
	public void testNullRulesLogging() {
		assertThrows(IllegalArgumentException.class, () -> {
			XssSanitizer sanitizer = new XssSanitizerImpl();
			sanitizer.setRules(null);
			logs.assertContains("Attempt to set the rules to null");
		});
	}
}
