package org.example;

import javax.crypto.SecretKey;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.security.Keys;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;

//
// Pingable at:
// http://localhost:8080/sso/api/demo/ping
//
@Path("/auth")
public class AuthResource {

	@GET
	@Path("/ping")
	public Response ping() {
		return Response.ok().entity("Service online").build();
	}

	@POST
	@Path("/verify/")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public Response postNotification(InputData tokenIn) throws Exception {

		final String secretString = "RockertSoftwareRocks2025ThisIsNotSecureEnough";
		SecretKey key = Keys.hmacShaKeyFor(Decoders.BASE64.decode(secretString));
		
		try 
		{
			JwtParser jwtParser = Jwts.parser()
					.verifyWith(key)
					.build();
			try 
			{
				jwtParser.parse(tokenIn.getToken());
			} 
			catch (Exception e)
			{
				Message message = new Message();
				message.setMesg("Could not verify JWT token integrity!, it maybe out of date");
				return Response.status(400).entity(message).build();
			}
			
			Claims claims = Jwts.parser()
					.setSigningKey(key)
					.build()
					.parseClaimsJws(tokenIn.getToken())
					.getBody();

			Credentials creds = new Credentials();
			creds.setfName(claims.get("first_name", String.class));
			creds.setlName(claims.get("last_name", String.class));
			creds.setLoc(claims.get("location", String.class));
			creds.setId(claims.get("id", Integer.class));
			creds.setDept(claims.get("department", String.class));
			creds.setTitle(claims.get("title", String.class));

			return Response.status(201).entity(creds).build();

		} 
		catch (Exception e)
		{
			Message message = new Message();
			message.setMesg(e.getLocalizedMessage());
			return Response.status(400).entity(message).build();
		}
	}
}
