package org.example.eval;


import javax.sql.DataSource;


public enum ResourceManager
{

    /** The singleton instance of the ResourceManager object. */
    INSTANCE;

    private static ResourceManagerImpl manager;

    /**
     * Static initializer to force use of the singleton methods.
     */
    static {
        manager = new ResourceManagerImpl();
    }

    /**
     *
     * Private constructor to enforce the singleton pattern.
     */
    private ResourceManager() {
        // private constructor to enforce the singleton pattern
    }

    public DataSource getDataSource()
    {
        return manager.getDS();
    }
    
    public void setDataSource(DataSource ds)
    {
        manager.setDS(ds);
    }
    

    private static class ResourceManagerImpl
    {
        private DataSource ds = null;
      
        private ResourceManagerImpl() {
            super();
        }

        DataSource getDS() {
            return ds;
        }

        void setDS(DataSource ds) {
            this.ds = ds;
        }

    }
}
