package org.example.eval;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

import javax.crypto.SecretKey;
import javax.sql.DataSource;

import org.apache.commons.dbutils.DbUtils;
import org.json.JSONObject;

import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.security.Keys;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

@WebServlet("/SSOServlet")
public class SSOServlet extends HttpServlet {
	private static final long serialVersionUID = 1L;

	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response) 
			throws ServletException, IOException
	{
		DataSource ds = ResourceManager.INSTANCE.getDataSource();
		final String FIND_DEPARTMENTS = "Select * from Departments";
		final String FIND_LOCATIONS = "Select country from Locations";
		final String FIND_TITLES = "SELECT DISTINCT title FROM employee";


		Statement stmt = null;
		Connection conn = null;
		ResultSet results = null;
		List<String> departments = new ArrayList<String>();
		try
		{
			conn = ds.getConnection();
			stmt = conn.createStatement();

			results = stmt.executeQuery(FIND_DEPARTMENTS);

			while (results.next())
			{
				String name = results.getString("Name");
				departments.add(name);
			}
		}
		catch (SQLException sqle)
		{
			throw new IllegalArgumentException(sqle);
		}
		finally
		{
			DbUtils.closeQuietly(conn, stmt, results);
		}


		stmt = null;
		results = null;
		List<String> locations = new ArrayList<String>();
		try
		{
			conn = ds.getConnection();
			stmt = conn.createStatement();

			results = stmt.executeQuery(FIND_LOCATIONS);

			while (results.next())
			{
				String country = results.getString("Country");
				locations.add(country);
			}
		}
		catch (SQLException sqle)
		{
			throw new IllegalArgumentException(sqle);
		}
		finally
		{
			DbUtils.closeQuietly(conn, stmt, results);
		}

		stmt = null;
		results = null;
		List<String> titles = new ArrayList<String>();
		try
		{
			conn = ds.getConnection();
			stmt = conn.createStatement();

			results = stmt.executeQuery(FIND_TITLES);

			while (results.next())
			{
				String title = results.getString("Title");
				titles.add(title);
			}
		}
		catch (SQLException sqle)
		{
			throw new IllegalArgumentException(sqle);
		}
		finally
		{
			DbUtils.closeQuietly(conn, stmt, results);
		}

		request.setAttribute("departments",  departments);
		request.setAttribute("locations",  locations);
		request.setAttribute("titles",  titles);
		String destination = "sso.jsp";
		RequestDispatcher requestDispatcher = request.getRequestDispatcher(destination);

		requestDispatcher.forward(request, response);  
	}

	@Override
	protected void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {

		String dept = request.getParameter("department");
		String location = request.getParameter("location");
		String title = request.getParameter("title");

		DataSource ds = ResourceManager.INSTANCE.getDataSource();

		final String FIND_EMPLOYEES = "SELECT id, first_name, last_name FROM employee WHERE department = (SELECT id FROM departments WHERE name = ? ) AND country = ? AND title = ?";

		PreparedStatement stmt = null;
		Connection conn = null;
		ResultSet results = null;
		String fName = null;
		String lName = null;
		try

		{
			conn = ds.getConnection();
			stmt = conn.prepareStatement(FIND_EMPLOYEES);
			stmt.setString(1,  dept);
			stmt.setString(2,  location);
			stmt.setString(3, title);

			results = stmt.executeQuery();

			JSONObject userObject = new JSONObject();

			if (results.next())
			{
				int id = results.getInt("Id");
				fName = results.getString("First_Name");
				lName = results.getString("Last_Name");
				userObject.put("id", id);
				userObject.put("first_Name", fName);
				userObject.put("last_Name", lName);
				userObject.put("location", location);
				userObject.put("department", dept);
				userObject.put("title", title);


				final String secretString = "RockertSoftwareRocks2025ThisIsNotSecureEnough";
				SecretKey key = Keys.hmacShaKeyFor(Decoders.BASE64.decode(secretString));

				Date now = new Date();
				Date expirationDate = new Date(now.getTime() + TimeUnit.MINUTES.toMillis(60));
				Map<String, Object> claims = new HashMap<>();
				claims.put("id", id);
				claims.put("first_name", fName);
				claims.put("last_name", lName);
				claims.put("location", location);
				claims.put("department", dept);
				claims.put("title", title);

				String builder =  Jwts.builder()
						.setIssuer("Auth Service")
						.setClaims(claims)
						.setSubject((fName + " " + lName))
						.setIssuedAt(now)
						.setExpiration(expirationDate)
						.signWith(key)
						.compact();

				userObject.put("token", builder);
				response.setContentType("application/json");
				response.setCharacterEncoding("UTF-8");
				String output = userObject.toString();
				response.getWriter().write(output); 
			}
			else {
				String output = "No Employees found";
				response.getWriter().write(output); 
			}
		}
		catch (SQLException sqle)
		{
			throw new IllegalArgumentException(sqle);
		}
		finally
		{
			DbUtils.closeQuietly(conn, stmt, results);
		}



	}
}