package org.example.eval;

import java.sql.Connection;
import java.sql.SQLException;

import org.apache.derby.jdbc.ClientDataSource;

import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.annotation.WebListener;


@WebListener
public class StartupListener implements ServletContextListener
{
    public void contextDestroyed(ServletContextEvent sce)
    {
        // do nothing, this is called when the Server is shutting down.
    }

    /**
     * @see ServletContextListener#contextInitialized(ServletContextEvent)
     */
    public void contextInitialized(ServletContextEvent sce)
    {
        try
        {
        	 ClientDataSource cds = new ClientDataSource();
             cds.setServerName("localhost");
             cds.setPortNumber(1527); // Default Derby network server port
             cds.setDatabaseName("hr");
             cds.setUser("HRDBA");
             cds.setPassword("HRDBA");

             try (Connection conn = cds.getConnection()) {
                 ResourceManager.INSTANCE.setDataSource(cds);
                 
             } catch (SQLException e) {
                 e.printStackTrace();
             }
     
        }
        catch (Exception e)
        {
            throw new RuntimeException("Cannot initialize the Database connection " + e.getLocalizedMessage());
        }  
 
    }

}
