package org.example.eval.entity;

import java.util.List;
import java.util.Objects;

public class QuizQuestion {
	private int tQuizNumber;
	private int tQuestionNumber;
	private String tQuestion;
	private List<QuizAnswer> answers;

	public QuizQuestion() {
		super();
	}

	public int gettQuizNumber() {
		return tQuizNumber;
	}

	public void settQuizNumber(int tQuizNumber) {
		this.tQuizNumber = tQuizNumber;
	}

	public int gettQuestionNumber() {
		return tQuestionNumber;
	}

	public void settQuestionNumber(int tQuestionNumber) {
		this.tQuestionNumber = tQuestionNumber;
	}

	public String gettQuestion() {
		return tQuestion;
	}

	public void settQuestion(String tQuestion) {
		this.tQuestion = tQuestion;
	}

	public List<QuizAnswer> getAnswers() {
		return answers;
	}

	public void setAnswers(List<QuizAnswer> answers) {
		this.answers = answers;
	}

	@Override
	public String toString() {
		return "TQuestion [tQuizNumber=" + tQuizNumber + ", tQuestionNumber=" + tQuestionNumber + ", tQuestion="
				+ tQuestion + ", answers=" + answers + "]";
	}

	@Override
	public int hashCode() {
		return Objects.hash(answers, tQuestion, tQuestionNumber, tQuizNumber);
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		QuizQuestion other = (QuizQuestion) obj;
		return Objects.equals(answers, other.answers) && Objects.equals(tQuestion, other.tQuestion)
				&& tQuestionNumber == other.tQuestionNumber && tQuizNumber == other.tQuizNumber;
	}

}
