package org.example.eval.entity;

import java.util.Objects;

public class UserCredentials {
	private int studentId;
	private String studentName;
	private int team;

	public UserCredentials() {
		super();
	}

	public int getStudentId() {
		return studentId;
	}

	public void setStudentId(int studentId) {
		this.studentId = studentId;
	}

	public String getStudentName() {
		return studentName;
	}

	public void setStudentName(String studetName) {
		this.studentName = studetName;
	}

	public int getTeam() {
		return team;
	}

	public void setTeam(int team) {
		this.team = team;
	}
	
	public String getTeamName() {
		switch (team) {
        case 2:
            return "Team White";
        case 3:
            return "Team Blue";
        case 4:
            return "Team Red";  
        case 5:
            return "Team Green";   
        case 6:
            return "Team Purple";   
        case 7:
            return "Team Yellow";  
        default:
        	return "Unassigned";
		}
	}

	@Override
	public int hashCode() {
		return Objects.hash(studentId, studentName, team);
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		UserCredentials other = (UserCredentials) obj;
		return studentId == other.studentId && Objects.equals(studentName, other.studentName) && team == other.team;
	}

	@Override
	public String toString() {
		return "UserCredentials [studentId=" + studentId + ", studetName=" + studentName + ", team=" + team + "]";
	}

}
