<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
	pageEncoding="ISO-8859-1" errorPage="error.jsp" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<!DOCTYPE html>
<html lang="en-us">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>	
	<script src="<c:url value='resources/app-ajax.js'/>" type="text/javascript"></script>		
	<link rel="stylesheet"
		href="<c:url value='/resources/sso.css'/>" />
	<title>Mock SSO</title>
</head>
<body>
	<header>
		<h2 class="center">The Mock SSO Login Site</h2>
	</header>
	<div id="wrap">
		<h1 class="center">Select a User to mock:</h1>
		<table>
		  <tr>
		    <td>
			  <label for="depart">Department:</label><br>
			  <select id="depart" name='depart'>
					<option value="" selected>Please Select The Department</option>
					<c:forEach items="${departments}" var="current">
						<option value="${current}">${current}</option>
					</c:forEach>
			  </select>
	       </td>
	       <td>
			  <label for="title">Title:</title'><br>
			  <select id="title" name='title'>
					<option value="" selected>Please Select The Title</option>
					<c:forEach items="${titles}" var="current">
						<option value="${current}">${current}</option>
					</c:forEach>
			  </select>
			</td>			
	       <td>
			  <label for="location">Location:</title'><br>
			  <select id="location" name='location'>
					<option value="" selected>Please Select The Location</option>		
					<c:forEach items="${locations}" var="current">
						<option value="${current}">${current}</option>
					</c:forEach>
			  </select>
			</td>				
		 </tr>
	  </table>
	  <br>
	  <br>
	  <button id="generate">Generate a Authentication Token</button>
	  <br>
	  <br>
	  <hr>
	  <br>
	  <br>
	  <span>Authentication Details</span>
	  <br>
	  <textarea id="details" rows="12" cols="120"></textarea>
	  <br>
	  <br>
	 
	</div>
	<c:if test="${not empty msg}">
		<span id="msg" class="message"><c:out value="${msg}" /></span>
	</c:if>
	<footer>
		<div class="right">
			<jsp:useBean id="now" class="java.util.Date" />
			<fmt:formatDate type="date" value="${now}" />
		</div>
	</footer>
</body>
</html>