<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
	pageEncoding="ISO-8859-1" errorPage="error.jsp" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<!DOCTYPE html>
<html lang="en-us">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
	<script src="https://code.jquery.com/ui/1.14.1/jquery-ui.js"></script>
	
	<script src="<c:url value='/resources/skills.js'/>" type="text/javascript"></script>	
		
	<link rel="stylesheet" href="https://code.jquery.com/ui/1.14.1/themes/base/jquery-ui.css">
	<link rel="stylesheet"
		href="<c:url value='/resources/eval.css'/>" >
	<title>Class Evaluation Web Site - Create Account</title>
</head>
<body>
	<header>
		<h2 class="center">Create Account:</h2>
	</header>
		<div id="wrap">
		<br>
		<br>
		<form method="post" action="CreateServlet">
		    <label for="selection">Name:</label><br>
			<select id="selection" name='id'>
				<option value="" selected>Please Select Your Name</option>
				<c:forEach items="${students}" var="current">
				    <c:set var="data" value="${fn:split(current, '@')}" />
					<option value="${data['0']}">${data['1']}</option>
				</c:forEach>
			</select>
			<br>
			<br>
			<label for="userid">Logon UserId:</label><br>
			<input type="text" id="userid" name="userid" required="required"></input>
			<br>
			<br>
			<fieldset id="password">
    			<legend>Password:</legend>
    			<label for="pass1">Password:</label><br>
    			<input type="password" id="pass1" name="pass1" placeholder="choose a password" required="required"><br><br>
    			<label for="pass2">Re-enter Password:</label><br>
    			<input type="password" id="pass2" name="pass2" placeholder="re-type your password" required="required" id="pass2"'><br><br>
    			<span id="passerr"></span>
  			</fieldset>
			<br>
			<br>
			<br>
			<br>
			<label for="vmimage">Assigned Virtual Machine Id:</label><br>
			<input type="text" id="vmimage" name="vmimage" required="required"></input>
			<br>
			<br>
			<fieldset>
			    <legend>Team:</legend>
			    <input type="radio" id="white" name="team" value="2">
			    <label for="write">White</label><br>
			    <input type="radio" id="blue" name="team" value="3">
			    <label for="red">Blue</label><br>
			    <input type="radio" id="red" name="team" value="4">
			    <label for="red">Red</label><br>
			    <input type="radio" id="green" name="team" value="5">
			    <label for="red">Green</label><br>			    
			    <input type="radio" id="purple" name="team" value="6">
			    <label for="red">Purple</label><br>
			    <input type="radio" id="yellow" name="team" value="7">
			    <label for="red">Yellow</label><br>
			</fieldset>
			<br>
			<br>
			<hr>
			<h2 class="center">Initial Self-Evaluation</h2>
			<p>
			<label for="leadership">Leadership:</label>&nbsp;
			<input type="text" readonly=""  id="leadership" name="leadership" style="font-weight:bold;" /> <br>
			</p>
			<div id="slider-leadership"></div>
			<p>
			<label for="lcomment">Leadership Comment:</label><br>
            <textarea id="lcomment" name="lcomment" rows="5" cols="40" maxlength="1024"></textarea><br>
            <br>
            <br>
            
			<label for="communication">Communication Skills:</label>
			<input type="text" readonly=""  id="communication" name="communication" style="font-weight:bold;" /> 
			</p>
			<div id="slider-communication"></div>
			<p>
			<label for="ccomment">Communication Comment:</label><br>
            <textarea id="ccomment" name="ccomment" rows="5" cols="40" maxlength="1024"></textarea><br>
            <br>
            <br>
            
			<label for="technical">Technical Skills:</label>
			<input type="text" readonly=""  id="technical" name="technical" style="font-weight:bold;" /> 			
			</p>
			<div id="slider-technical"></div>
			<p>
			<label for="tcomment">Technical Skills Comment:</label><br>
            <textarea id="tcomment" name="tcomment" rows="5" cols="40" maxlength="1024"></textarea><br>
            <br>
            <br>
            			
			<label for="security">Security Awareness:</label>
			<input type="text" readonly=""  id="security" name="security" style="font-weight:bold;" /> 			
			</p>
			<div id="slider-security"></div>
			<p>
			<label for="scomment">Security AwarenessComment:</label><br>
            <textarea id="scomment" name="scomment" rows="5" cols="40" maxlength="1024"></textarea><br>
            <br>
            <br>
            			
			<label for="presentation">Presentation Skills:</label>
			<input type="text" readonly=""  id="presentation" name="presentation" style="font-weight:bold;" /> 
			</p>
			<div id="slider-presentation"></div>	
			<p>
			<label for="pcomment">Presentation SkillsComment:</label><br>
            <textarea id="pcomment" name="pcomment" rows="5" cols="40" maxlength="1024"></textarea><br>
            <br>
            <br>
            														
 			<br>
			<br>
			<input type="submit" />
		</form>
		<br>
		<br>
		<c:if test="${not empty msg}">
			<span id="msg" class="message"><c:out value="${msg}" /></span>
		</c:if>
	</div>
	<c:if test="${not empty msg}">
		<span id="msg" class="message"><c:out value="${msg}" /></span>
	</c:if>
	<footer>
		<div class="right">
			<jsp:useBean id="now" class="java.util.Date" />
			<fmt:formatDate type="date" value="${now}" />
		</div>
	</footer>
</body>
</html>