<?xml version="1.0" encoding="ISO-8859-1" ?>
<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
	pageEncoding="ISO-8859-1" errorPage="error.jsp" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<!DOCTYPE html>
<html lang="en-us">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
	<link rel="stylesheet"
		href="<c:url value='/resources/eval.css'/>" />
	<title>Class Evaluation Web Site - Topic Quiz</title>
</head>
<body>
	<header>
		<h2 class="center">${quiz.tQuizName}</h2>
		<h3 class="center">${credentials.studentName}</h3>
	</header>
	<div id="wrap">
		<br>
		<br>
		<form method="post" action="TQ/${quiz.tQuizNumber}">
			<table>
			  <tboby>
				<c:forEach items="${quiz.questions}" var="question">
				    <tr>
					  <td class="bold">
					  	<fieldset id="question">
							  <legend> ${question.tQuestion} </legend>
							  <c:forEach items="${question.answers}" var="answer">
							    <input type="radio" id="q${question.tQuestionNumber}-${answer.tAnswerNumber}" 
										name="q${question.tQuestionNumber}" value="${answer.tAnswerNumber}">
			    				<label for="q${question.tQuestionNumber}-${answer.tAnswerNumber}">${answer.tQuizAnswer}</label><br>
					          </c:forEach>
					          <input type="radio" id="q${question.tQuestionNumber}-5" 
										name="q${question.tQuestionNumber}" value="5">
			    				<label for="q${question.tQuestionNumber}-5">Do not know</label><br>
					     </fieldset>
					  </td>  
					</tr>
				</c:forEach>
			  </tboby>
			</table>
			<input type="submit" />
		</form>
		<br>
		<br>
		<c:if test="${not empty msg}">
			<span id="msg" class="message"><c:out value="${msg}" /></span>
		</c:if>
	</div>
	<c:if test="${not empty msg}">
		<span id="msg" class="message"><c:out value="${msg}" /></span>
	</c:if>
	<footer>
		<div class="right">
			<jsp:useBean id="now" class="java.util.Date" />
			<fmt:formatDate type="date" value="${now}" />
		</div>
	</footer>
</body>
</html>