<?xml version="1.0" encoding="ISO-8859-1" ?>
<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
	pageEncoding="ISO-8859-1" errorPage="error.jsp" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<!DOCTYPE html>
<html lang="en-us">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
	<link rel="stylesheet"
		href="<c:url value='/resources/eval.css'/>" />
	<title>Class Evaluation Web Site - Topic Quiz - Response</title>
</head>
<body>
	<header>
		<h2 class="center">${quiz.tQuizName}</h2>
		<h3 class="center">${credentials.studentName} - Score: ${score}%</h3>
	</header>
	<div id="wrap">
		<br>
		<br>
			<table>
			  <tboby>
				<c:forEach items="${quiz.questions}" var="question" varStatus="index1">
				    <tr>
				      <td>
				        <c:set var="current" value="${index1.index}"/> 
				      	<span>${responses[current]}</span>
				      </td>
					  <td class="bold">
					  	<fieldset id="question">
							  <legend> ${question.tQuestion} </legend>
							  <c:forEach items="${question.answers}" var="answer" varStatus="index">
							    <span>${index.count}</span> 
			    				<span>${answer.tQuizAnswer}</span><br>
					          </c:forEach>
					          <span>5</span> 
			    			  <span>Do not know</span><br>
					     </fieldset>
					  </td>  
					</tr>
				</c:forEach>
			  </tboby>
			</table>
			<a href="/eval/landing.jsp">Return to master list</a>
		<br>
		<br>
		<c:if test="${not empty msg}">
			<span id="msg" class="message"><c:out value="${msg}" /></span>
		</c:if>
	</div>
	<c:if test="${not empty msg}">
		<span id="msg" class="message"><c:out value="${msg}" /></span>
	</c:if>
	<footer>
		<div class="right">
			<jsp:useBean id="now" class="java.util.Date" />
			<fmt:formatDate type="date" value="${now}" />
		</div>
	</footer>
</body>
</html>