<?xml version="1.0" encoding="ISO-8859-1" ?>
<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
	pageEncoding="ISO-8859-1" errorPage="error.jsp" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<!DOCTYPE html>
<html lang="en-us">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
	<script src="https://code.jquery.com/ui/1.14.1/jquery-ui.js"></script>
	<link rel="stylesheet" href="https://code.jquery.com/ui/1.14.1/themes/base/jquery-ui.css">
	<link rel="stylesheet"
		href="<c:url value='resources/eval.css'/>" />
	<script src="<c:url value='resources/skills.js'/>" type="text/javascript"></script>		
	<title>Class Evaluation Web Site - Topic Quizzes</title>
</head>
<body>
	<header>
		<h2 class="center">Topic Quizzes:</h2>
		<h3 class="center">${credentials.studentName}</h3>
	</header>
	<div id="wrap">
		<br>
		<br>
		<table>
		  <thead>
		    <tr>
		      <th class="padded bigger">Quiz</th>
		      <th class="padded bigger">Status</th>
		    </tr>
		  </thead>
		  <tboby>
			<c:forEach items="${quizzes}" var="current" varStatus="var">
			    <tr style="padding: 10px;">
			      <c:set var="data" value="${fn:split(current, '@')}" />
				  <td class="bold padded">${data[0]}</td>  
				  <td class="bold padded">
				    <c:choose>
				      <c:when test="${data[1] == 'O' }">
				         <span>Completed</span>
				      </c:when>
				      <c:otherwise>
				         <a href="TQ/${var.count}" >Not Yet Completed</a>
				      </c:otherwise>
				    </c:choose>
				  </td> 
				</tr>
			</c:forEach>
		  </tboby>
		</table>
		<br>
		<br>
		<c:if test="${not empty msg}">
			<span id="msg" class="message"><c:out value="${msg}" /></span>
		</c:if>
	</div>
	<c:if test="${not empty msg}">
		<span id="msg" class="message"><c:out value="${msg}" /></span>
	</c:if>
	<footer>
		<div class="right">
			<jsp:useBean id="now" class="java.util.Date" />
			<fmt:formatDate type="date" value="${now}" />
		</div>
	</footer>
</body>
</html>