<?xml version="1.0" encoding="ISO-8859-1" ?>
<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
	pageEncoding="ISO-8859-1" errorPage="error.jsp" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<!DOCTYPE html>
<html lang="en-us">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
	<script src="https://code.jquery.com/ui/1.14.1/jquery-ui.js"></script>
	<link rel="stylesheet" href="https://code.jquery.com/ui/1.14.1/themes/base/jquery-ui.css">
	<link rel="stylesheet"
		href="<c:url value='resources/eval.css'/>" />
	<script src="<c:url value='resources/skills.js'/>" type="text/javascript"></script>		
	<title>Class Evaluation Web Site - Self Team Evaluation</title>
</head>
<body>
	<header>
		<h2 class="center">Self Team Evaluation - ${credentials.teamName}</h2>
		<h3 class="center">${credentials.studentName}</h3>
	</header>
	<div id="wrap">
	    <h2>${title}</h2>
		<br>
		<br>
		<form method="post" action="SelfTeamEvalServlet">
		    <input type="hidden" id="week" name="week" value="${week}" >
			<fieldset>
			    <legend>Team member being evaluated:</legend>
				<c:forEach items="${teammembers}" var="varstudent">
				    <c:set var="data" value="${fn:split(varstudent, '@')}" />
				 	<input type="radio" id="${data[0]}" name="teammember" value="${data[0]}">
			    	<label for="${data[0]}">${data[1]}</label><br>
				</c:forEach>
			</fieldset>
			<br>
			<br>
			<hr>
			<h2 class="center">Self Team Evaluation</h2>
			<p>
			<label for="leadership">Leadership:</label>&nbsp;
			<input type="text" readonly=""  id="leadership" name="leadership" style="font-weight:bold;" /> <br>
			</p>
			<div id="slider-leadership"></div>
			<p>
			<label for="lcomment">Leadership Comment:</label><br>
            <textarea id="lcomment" name="lcomment" rows="5" cols="40" maxlength="1024"></textarea><br>
            <br>
            <br>
            
			<label for="communication">Communication Skills:</label>
			<input type="text" readonly=""  id="communication" name="communication" style="font-weight:bold;" /> 
			</p>
			<div id="slider-communication"></div>
			<p>
			<label for="ccomment">Communication Comment:</label><br>
            <textarea id="ccomment" name="ccomment" rows="5" cols="40" maxlength="1024"></textarea><br>
            <br>
            <br>
            
			<label for="technical">Technical Skills:</label>
			<input type="text" readonly=""  id="technical" name="technical" style="font-weight:bold;" /> 			
			</p>
			<div id="slider-technical"></div>
			<p>
			<label for="tcomment">Technical Skills Comment:</label><br>
            <textarea id="tcomment" name="tcomment" rows="5" cols="40" maxlength="1024"></textarea><br>
            <br>
            <br>
            			
			<label for="security">Security Awareness:</label>
			<input type="text" readonly=""  id="security" name="security" style="font-weight:bold;" /> 			
			</p>
			<div id="slider-security"></div>
			<p>
			<label for="scomment">Security AwarenessComment:</label><br>
            <textarea id="scomment" name="scomment" rows="5" cols="40" maxlength="1024"></textarea><br>
            <br>
            <br>
            			
			<label for="presentation">Presentation Skills:</label>
			<input type="text" readonly=""  id="presentation" name="presentation" style="font-weight:bold;" /> 
			</p>
			<div id="slider-presentation"></div>	
			<p>
			<label for="pcomment">Presentation SkillsComment:</label><br>
            <textarea id="pcomment" name="pcomment" rows="5" cols="40" maxlength="1024"></textarea><br>
            <br>
            <br>
            <br>													
			<br>
			<input type="submit" /> &nbsp; &nbsp; <a href="/eval/landing.jsp">Return to Menu</a>
		</form>
		<br>
		<br>
		<c:if test="${not empty msg}">
			<span id="msg" class="message"><c:out value="${msg}" /></span>
		</c:if>
	</div>
	<footer>
		<div class="right">
			<jsp:useBean id="now" class="java.util.Date" />
			<fmt:formatDate type="date" value="${now}" />
		</div>
	</footer>
</body>
</html>	