<?xml version="1.0" encoding="ISO-8859-1" ?>
<%@ page language="java" contentType="text/html; charset=ISO-8859-1"
	pageEncoding="ISO-8859-1" errorPage="error.jsp" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<!DOCTYPE html>
<html lang="en-us">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
	<script src="https://code.jquery.com/ui/1.14.1/jquery-ui.js"></script>
	<link rel="stylesheet" href="https://code.jquery.com/ui/1.14.1/themes/base/jquery-ui.css">
	<link rel="stylesheet"
		href="<c:url value='resources/eval.css'/>" />
	<script src="<c:url value='resources/skills.js'/>" type="text/javascript"></script>		
	<title>Class Evaluation Web Site - Self team Evaluation</title>
</head>
<body>
	<header>
		<h2 class="center">Self team Evaluation - ${credentials.teamName}</h2>
		<h3 class="center">${credentials.studentName}</h3>
	</header>
	<div id="wrap">
		<br>
		<br>
		<form method="post" action="SelfTeamEvalServlet">
			<fieldset>
			    <legend>Team:</legend>
				<c:forEach items="${teams}" var="varteam">
				    <c:if test="${not (credentials.team == varteam.id)}">
				 		<input type="radio" id="{${varteam.name}}" name="team" value="${varteam.id}">
			    		<label for=""{${varteam.name}}"">"{${varteam.name}}"</label><br>
			    	</c:if>
				</c:forEach>
			</fieldset>
			<br>
			<br>
			<hr>
			<h2 class="center">Self Team Evaluation</h2>
			<p>
			<label for="leadership">Leadership:</label>&nbsp;
			<input type="text" readonly=""  id="leadership" name="leadership" style="font-weight:bold;" /> 
			</p>
			<div id="slider-leadership"></div>
			<p>
			<label for="communication">Communication Skills:</label>
			<input type="text" readonly=""  id="communication" name="communication" style="font-weight:bold;" /> 
			</p>
			<div id="slider-communication"></div>
			<p>
			<label for="technical">Technical Skills:</label>
			<input type="text" readonly=""  id="technical" name="technical" style="font-weight:bold;" /> 
			</p>
			<div id="slider-technical"></div>
			<p>
			<label for="security">Security Awareness:</label>
			<input type="text" readonly=""  id="security" name="security" style="font-weight:bold;" /> 
			</p>
			<div id="slider-security"></div>
			<p>
			<label for="presentation">Presentation Skills:</label>
			<input type="text" readonly=""  id="presentation" name="presentation" style="font-weight:bold;" /> 
			</p>
			<div id="slider-presentation"></div>												
 			<br>
			<br>
			<input type="submit" />
			<input type="submit" />
		</form>
		<br>
		<br>
		<c:if test="${not empty msg}">
			<span id="msg" class="message"><c:out value="${msg}" /></span>
		</c:if>
	</div>
	<c:if test="${not empty msg}">
		<span id="msg" class="message"><c:out value="${msg}" /></span>
	</c:if>
	<footer>
		<div class="right">
			<jsp:useBean id="now" class="java.util.Date" />
			<fmt:formatDate type="date" value="${now}" />
		</div>
	</footer>
</body>
</html>	