#
# A Python wrapper around the world_bank REST API
#

import world_bank   # import the world_bank package

print(''' 
    Please select a Region using the Codes below:
    ''')

regions = world_bank.api.getListOfRegions()
for key, value in regions.items() :
    print('\t', key, ' - ', value)
    
print("\n")
input_data = input("Your Selection: ")

print(input_data)

try:
    results = world_bank.api.getListOfCountriesByRegion(input_data)
    print("Please select a Country (by number):")
except LookupError as oops:
    print(oops)
    print("Goodbye")
    exit()

for (i,x) in enumerate(results) :
    print("{0:3d}:\t{1} - {2}".format((i + 1), x.getCode(), x.getName())) 

try:
    selection = input("Your Selection: ")
    data = results[int(selection) - 1]
except  (IndexError, ValueError) as oops:
    print(oops)
    print("Goodbye")
    exit()

print(data)
