'''
    This is the wrapper around the World Bank REST Web Service.
    
'''
# main logic 

import urllib.request
import xml.etree.ElementTree as ET

regions = {'ARB':'Arab World','EMU':'Euro Area','EUU':'European Union','LDC':'Least Developed Countries', 
           'OED':'OECD Members (Organisation for Economic Co-operation and Development)','WLD':'World', 
           'EAP':'East Asia & Pacific','ECA':'Europe & Central Asia','LAC':'Latin America & Caribbean', 
           'MNA':'Middle East & North Africa','SAS':'South Asia','SSA':'Sub-Saharan Africa','CSS':'Caribbean small states', 
           'OSS':'Other small states','PSS':'Pacific island small states','SST':'Small states'}
           
formats = ('xml','json')
           
worldBankURL = 'http://api.worldbank.org/v2/country?per_page=1000&region={}&format={}'
countryURL = 'http://api.worldbank.org/v2/countries/{}?format=xml'

#   proxy=urllib2.ProxyHandler({'http':'proxy.xyzcorp.com:3128'})
#   opener=urllib2.build_opener(proxy)
#   urllib2.install_opener(opener)

def listRegions() :
    ' This function provides a dictionary of World Bank Regions, {code:name} '
    return regions           

def pullData(region, format) :
    ' This function makes the RESTService call, the region must be valid and the format must be xml or json '
    if region not in regions :
        raise LookupError("Region: {} not found".format(region))
    if format not in formats :
        raise LookupError("Format: {} not found".format(region))      
    restURL = worldBankURL.format(region, format)
    response = urllib.request.urlopen(restURL).read()
    
    if format == 'xml' :
        tree = ET.fromstring(response)
        if "{http://www.worldbank.org}error" in tree:
            raise LookupError("Region: {} not found".format(region))
    else :
        response = str(response, encoding='utf8')
        if "message" in response:
            raise LookupError("Region: {} not found".format(region))
    
    return response
    
def pullCountryData(country) :
    ' This function makes the RESTService call, the country code must be valid '
    restURL = countryURL.format(country)
  
    with urllib.request.urlopen(restURL) as site:
        response = site.read()
        tree = ET.fromstring(response)
    
    if "{http://www.worldbank.org}message" in tree:
        raise LookupError("Country: {} not found".format(country))
            
    return response
    
if __name__ == '__main__' :

    # my tests
    # tests for listRegions()
    if not len(listRegions()) == 16 : raise AssertionError("listRegions not returning 16")
   
    # tests for pullData
    pullData('ARB', 'xml')   #  these should work
    pullData('PSS', 'json') 
   
    try :
        pullData(None, 'xml')  # this should fail
        raise AssertionError("pulled 'None' region")
    except LookupError :
        pass            # do nothing, expected
        
    try :
        pullData('SAS', None)  # this should fail
        raise AssertionError("pulled 'None' format")
    except LookupError :
        pass            # do nothing, expected        
    
    if not len(pullData('SAS', 'xml')) > 0 : raise AssertionError("no data returned from REST call")
    if not len(pullData('EUU', 'json')) > 0 : raise AssertionError("no data returned from REST call")
    
    # tests for pullCountryData   
    pullCountryData('br')   # these should work
    pullCountryData('ca')   
    
    try :
        pullCountryData(None)  # this should fail
        raise AssertionError("pulled 'None' country")
    except LookupError :
        pass            # do nothing, expected
        
    try :
        pullData('XY', None)  # this should fail
        raise AssertionError("pulled 'XY' format")
    except LookupError :
        pass            # do nothing, expected     
    
    try :
        pullData('XY','xml')  # this should fail
        raise AssertionError("pulled 'XY' Country")
    except LookupError :
        pass            # do nothing, expected     
    
    try :
        pullData('CSS','xyz')  # this should fail
        raise AssertionError("pulled 'xyz' format")
    except LookupError :
        pass 
